% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrierScore.R
\name{BrierScore}
\alias{BrierScore}
\alias{.BrierScore}
\title{Compute Brier Score And Its Decomposition And Brier Skill Score}
\usage{
BrierScore(obs, pred, thresholds = seq(0, 1, 0.1))

.BrierScore(exp, obs, thresholds = seq(0, 1, 0.1))
}
\arguments{
\item{obs}{Vector of binary observations (1 or 0).}

\item{pred}{Vector of probablistic predictions with values in the range [0,1].}

\item{thresholds}{Values used to bin the forecasts. By default the bins are 
{[0,0.1), [0.1, 0.2), ... [0.9, 1]}.}

\item{exp}{Matrix of predictions with values in the range [0,1] for the 
.BrierScore function}
}
\value{
Both BrierScore and .Brier score provide the same outputs:
\itemize{ 
 \item{$rel}{standard reliability}
 \item{$res}{standard resolution}
 \item{$unc}{standard uncertainty}  
 \item{$bs}{Brier score}
 \item{$bs_check_res}{rel-res+unc}
 \item{$bss_res}{res-rel/unc}
 \item{$gres}{generalized resolution}
 \item{$bs_check_gres}{rel-gres+unc}
 \item{$bss_gres}{gres-rel/unc}
 \item{$rel_bias_corrected}{bias-corrected rel}
 \item{$gres_bias_corrected}{bias-corrected gres}
 \item{$unc_bias_corrected}{bias-corrected unc}
 \item{$bss_bias_corrected}{gres_bias_corrected-rel_bias_corrected/unc_bias_corrected}
 \item{$nk}{number of forecast in each bin}
 \item{$fkbar}{average probability of each bin}
 \item{$okbar}{relative frequency that the observed event occurred}
 \item{$bins}{bins used}
 \item{$pred}{values with which the forecasts are verified}
 \item{$obs}{probability forecasts of the event}
}
}
\description{
Computes the Brier score (BS) and the components of its standard 
decomposition as well with the two within-bin components described in 
Stephenson et al., (2008). It also returns the bias-corrected decomposition 
of the BS (Ferro and Fricker, 2012). BSS having the climatology as the 
reference forecast. \cr\cr
.BrierScore provides the same functionality, but taking a matrix of ensemble 
members (exp) as input.
}
\examples{
# Minimalist examples with BrierScore
a <- runif(10)
b <- round(a)
x <- BrierScore(b, a)
x$bs - x$bs_check_res
x$bs - x$bs_check_gres
x$rel_bias_corrected - x$gres_bias_corrected + x$unc_bias_corrected
 \dontrun{
a <- runif(10)
b <- cbind(round(a),round(a)) # matrix containing 2 identical ensemble members...
x2 <- BrierScore(a, b)
 }

# Example of BrierScore using UltimateBrier
# See ?UltimateBrier for more information
example(Load)
clim <- Clim(sampleData$mod, sampleData$obs)
ano_exp <- Ano(sampleData$mod, clim$clim_exp)
ano_obs <- Ano(sampleData$obs, clim$clim_obs)
bs <- UltimateBrier(ano_exp, ano_obs, thr = c(1/3, 2/3))

 \dontrun{
# Example of .BrierScore with veriApply
require(easyVerification)
BrierScore2 <- s2dverification:::.BrierScore
bins_ano_exp <- ProbBins(ano_exp, thr = c(1/3, 2/3), posdates = 3, posdim = 2)
bins_ano_obs <- ProbBins(ano_obs, thr = c(1/3, 2/3), posdates = 3, posdim = 2)
bs2 <- veriApply("BrierScore2", bins_ano_exp, Mean1Dim(bins_ano_ob,s 3), 
                tdim = 2, ensdim = 3)
 }
}
\references{
Wilks (2006) Statistical Methods in the Atmospheric Sciences.\cr
Stephenson et al. (2008). Two extra components in the Brier score decomposition. 
 Weather and Forecasting, 23: 752-757.\cr
Ferro and Fricker (2012). A bias-corrected decomposition of the BS. 
 Quarterly Journal of the Royal Meteorological Society, DOI: 10.1002/qj.1924.
}
\author{
History:\cr
 0.1 - 2012-04 (L. Rodrigues) - Original code\cr
 0.2 - 2017-02 (A. Hunter, \email{alasdair.hunter@bsc.es}) - Adapted to veriApply()
}
\keyword{datagen}
