% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spread.R
\name{Spread}
\alias{Spread}
\title{Compute interquartile range, maximum-minimum, standard deviation and median
absolute deviation}
\usage{
Spread(
  data,
  compute_dim = "member",
  na.rm = TRUE,
  conf = TRUE,
  conf.lev = 0.95,
  ncores = NULL
)
}
\arguments{
\item{data}{A numeric vector or array with named dimensions to compute the 
statistics. The dimensions should at least include 'compute_dim'.}

\item{compute_dim}{A vector of character strings of the dimension names along 
which to compute the statistics. The default value is 'member'.}

\item{na.rm}{A logical value indicating if NAs should be removed (TRUE) or
kept (FALSE) for computation. The default value is TRUE.}

\item{conf}{A logical value indicating whether to compute the confidence 
intervals or not. The default value is TRUE.}

\item{conf.lev}{A numeric value of the confidence level for the computation. 
The default value is 0.95.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list of numeric arrays with the same dimensions as 'data' but without
'compute_dim' and with the first dimension 'stats'. If 'conf' is TRUE, the 
length of 'stats' is 3 corresponding to the lower limit of the confidence 
interval, the spread, and the upper limit of the confidence interval. If 
'conf' is FALSE, the length of 'stats' is 1 corresponding to the spread.
\item{$iqr}{
 InterQuartile Range.
}
\item{$maxmin}{
 Maximum - Minimum.
}
\item{$sd}{
 Standard Deviation.
}
\item{$mad}{
 Median Absolute Deviation.
}
}
\description{
Compute interquartile range, maximum-minimum, standard deviation and median
absolute deviation along the list of dimensions provided by the compute_dim 
argument (typically along the ensemble member and start date dimension).
The confidence interval is computed by bootstrapping by 100 times. The input
data can be the output of \code{Load()}, \code{Ano()}, or 
\code{Ano_CrossValid()}, for example.
}
\examples{
# Load sample data as in Load() example:
example(Load)
clim <- Clim(sampleData$mod, sampleData$obs)
ano_exp <- Ano(sampleData$mod, clim$clim_exp)
runmean_months <- 12
smooth_ano_exp <- Smoothing(ano_exp, runmeanlen = runmean_months)
smooth_ano_exp_m_sub <- smooth_ano_exp - InsertDim(MeanDims(smooth_ano_exp, 'member', 
                                                           na.rm = TRUE), 
                                                  posdim = 3, 
                                                  lendim = dim(smooth_ano_exp)['member'], 
                                                  name = 'member')
spread <- Spread(smooth_ano_exp_m_sub, compute_dim = c('member', 'sdate'))

\dontrun{
PlotVsLTime(Reorder(spread$iqr, c('dataset', 'stats', 'ftime')), 
           toptitle = "Inter-Quartile Range between ensemble members",
           ytitle = "K", monini = 11, limits = NULL, 
           listexp = c('CMIP5 IC3'), listobs = c('ERSST'), biglab = FALSE, 
           hlines = c(0))
PlotVsLTime(Reorder(spread$maxmin, c('dataset', 'stats', 'ftime')), 
           toptitle = "Maximum minus minimum of the members", 
           ytitle = "K", monini = 11, limits = NULL, 
           listexp = c('CMIP5 IC3'), listobs = c('ERSST'), biglab = FALSE, 
           hlines = c(0))
PlotVsLTime(Reorder(spread$sd, c('dataset', 'stats', 'ftime')), 
           toptitle = "Standard deviation of the members", 
           ytitle = "K", monini = 11, limits = NULL, 
           listexp = c('CMIP5 IC3'), listobs = c('ERSST'), biglab = FALSE, 
           hlines = c(0))
PlotVsLTime(Reorder(spread$mad, c('dataset', 'stats', 'ftime')), 
           toptitle = "Median Absolute Deviation of the members",
           ytitle = "K", monini = 11, limits = NULL, 
           listexp = c('CMIP5 IC3'), listobs = c('ERSST'), biglab = FALSE, 
           hlines = c(0))
}

}
