% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToyModel.R
\name{ToyModel}
\alias{ToyModel}
\title{Synthetic forecast generator imitating seasonal to decadal forecasts. The
components of a forecast: (1) predictabiltiy (2) forecast error (3) 
non-stationarity and (4) ensemble generation. The forecast can be computed 
for real observations or observations generated artifically.}
\usage{
ToyModel(
  alpha = 0.1,
  beta = 0.4,
  gamma = 1,
  sig = 1,
  trend = 0,
  nstartd = 30,
  nleadt = 4,
  nmemb = 10,
  obsini = NULL,
  fxerr = NULL
)
}
\arguments{
\item{alpha}{Predicabiltiy of the forecast on the observed residuals 
Must be a scalar 0 < alpha < 1.}

\item{beta}{Standard deviation of forecast error 
Must be a scalar 0 < beta < 1.}

\item{gamma}{Factor on the linear trend to sample model uncertainty. Can be 
a scalar or a vector of scalars -inf < gammay < inf.
Defining a scalar results in multiple forecast, corresponding to different 
models with different trends.}

\item{sig}{Standard deviation of the residual variability of the forecast.
If observations are provided 'sig' is computed from the observations.}

\item{trend}{Linear trend of the forecast. The same trend is used for each 
lead-time. If observations are provided the 'trend' is computed from the 
observations, with potentially different trends for each lead-time. The 
trend has no unit and needs to be defined according to the time vector 
[1,2,3,... nstartd].}

\item{nstartd}{Number of start-dates of the forecast. 
If observations are provided the 'nstartd' is computed from the observations.}

\item{nleadt}{Number of lead-times of the forecats.
If observations are provided the 'nleadt' is computed from the observations.}

\item{nmemb}{Number of members of the forecasts.}

\item{obsini}{Observations that can be used in the synthetic forecast coming 
from Load (anomalies are expected). If no observations are provided 
artifical observations are generated based on Gaussian variaiblity with 
standard deviation from 'sig' and linear trend from 'trend'.}

\item{fxerr}{Provides a fixed error of the forecast instead of generating 
one from the level of beta. This allows to perform pair of forecasts with 
the same conditional error as required for instance in an attribution context.}
}
\value{
List of forecast with $mod including the forecast and $obs the 
 observations. The dimensions correspond to 
 c(length(gamma), nmemb, nstartd, nleadt)
}
\description{
The toymodel is based on the model presented in Weigel et al. (2008) QJRS
with an extension to consider non-stationary distributions prescribing a
linear trend. The toymodel allows to generate an aritifical forecast
based on obsevations provided by the input (from Load) or artificially
generated observations based on the input parameters (sig, trend). 
The forecast can be specfied for any number of start-dates, lead-time and 
ensemble members. It imitates components of a forecast: (1) predictabiltiy
(2) forecast error (3) non-stationarity and (4) ensemble generation. 
The forecast can be computed for real observations or observations generated
artifically.
}
\examples{
# Example 1: Generate forecast with artifical observations
# Seasonal prediction example
a <- 0.1
b <- 0.3
g <- 1
sig <- 1
t <- 0.02
ntd <- 30
nlt <- 4
nm <- 10
toyforecast <- ToyModel(alpha = a, beta = b, gamma = g, sig = sig, trend = t, 
                       nstartd = ntd, nleadt = nlt, nmemb = nm)

# Example 2: Generate forecast from loaded observations
# Decadal prediction example
 \dontrun{
data_path <- system.file('sample_data', package = 's2dv')
expA <- list(name = 'experiment', path = file.path(data_path,
            'model/$EXP_NAME$/$STORE_FREQ$_mean/$VAR_NAME$_3hourly',
            '$VAR_NAME$_$START_DATE$.nc'))
obsX <- list(name = 'observation', path = file.path(data_path,
            '$OBS_NAME$/$STORE_FREQ$_mean/$VAR_NAME$',
            '$VAR_NAME$_$YEAR$$MONTH$.nc'))

# Now we are ready to use Load().
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- Load('tos', list(expA), list(obsX), startDates,
                  output = 'areave', latmin = 27, latmax = 48,
                  lonmin = -12, lonmax = 40)
 }
 \dontshow{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- s2dv:::.LoadSampleData('tos', c('experiment'),
                                               c('observation'), startDates,
                                               output = 'areave',
                                               latmin = 27, latmax = 48,
                                               lonmin = -12, lonmax = 40)
 }

a <- 0.1
b <- 0.3
g <- 1
nm <- 10

toyforecast <- ToyModel(alpha = a, beta = b, gamma = g, nmemb = nm, 
                       obsini = sampleData$obs, nstartd = 5, nleadt = 60)
## Add PlotAno() back when this function is included!!
#  \donttest{
#PlotAno(toyforecast$mod, toyforecast$obs, startDates, 
#        toptitle = c("Synthetic decadal temperature prediction"), 
#        fileout = "ex_toymodel.eps")
#  }

}
