% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Smoothing.R
\name{Smoothing}
\alias{Smoothing}
\title{Smooth an array along one dimension}
\usage{
Smoothing(data, time_dim = "ftime", runmeanlen = 12, ncores = NULL)
}
\arguments{
\item{data}{A numerical array to be smoothed along one of its dimension 
(typically the forecast time dimension).}

\item{time_dim}{A character string indicating the name of the dimension to be 
smoothed along. The default value is 'ftime'.}

\item{runmeanlen}{An integer indicating the running mean length of sampling 
units (typically months). The default value is 12.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A numerical array with the same dimensions as parameter 'data' but 
 the 'time_dim' dimension is moved to the first. The head and tail part which
 do not have enough neighboring data for smoothing is assigned as NA.
}
\description{
Smooth an array of any number of dimensions along one dimension.
}
\examples{
# Load sample data as in Load() example:
example(Load)
clim <- Clim(sampleData$mod, sampleData$obs)
ano_exp <- Ano(sampleData$mod, clim$clim_exp)
ano_obs <- Ano(sampleData$obs, clim$clim_obs)
smooth_ano_exp <- Smoothing(ano_exp, time_dim = 'ftime', runmeanlen = 12)
smooth_ano_obs <- Smoothing(ano_obs, time_dim = 'ftime', runmeanlen = 12)
smooth_ano_exp <- Reorder(smooth_ano_exp, c(2, 3, 4, 1))
smooth_ano_obs <- Reorder(smooth_ano_obs, c(2, 3, 4, 1))
 \donttest{
PlotAno(smooth_ano_exp, smooth_ano_obs, startDates, 
       toptitle = "Smoothed Mediterranean mean SST", ytitle = "K",
       fileout = "tos_smoothed_ano.png")
 }
}
