% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_cont.R
\name{construct_cont}
\alias{construct_cont}
\title{Construct containers list}
\usage{
construct_cont(
  default_cont = "bioconductor/bioconductor_docker",
  default_tag = "devel",
  cont = list(paste(default_cont, default_tag, sep = ":"), NULL, NULL),
  versions_explicit = FALSE,
  run_check_cont = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{default_cont}{The DockerHub container to default to.
Used when it's detected that only the tag has been given in one or more 
\code{cont} entry.}

\item{default_tag}{The DockerHub container tag to default to.}

\item{cont}{Which Docker container to use on each OS
(\code{NULL} means no container will be used for that OS).
See 
\href{https://hub.docker.com/r/bioconductor/bioconductor_docker/tags}{here}
 for a list of all official Bioconductor Docker container versions.}

\item{versions_explicit}{Specify R/Bioc versions explicitly
(e.g. \code{r: 4.2.0, bioc: 3.16}) 
as opposed to flexibly (e.g. \code{r: "latest", bioc: "release"}).}

\item{run_check_cont}{Check whether the requested container repo 
(and the tag, if specified) exist using \link[rworkflows]{check_cont}.}

\item{verbose}{Print messages.}
}
\value{
Named list of containers
}
\description{
Construct containers list
}
\examples{
cont <- construct_cont() 
}
