% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_dataset_list.R
\name{w_datasets}
\alias{w_datasets}
\title{List all the available datasets from Webstat (codes and names) in a table. No arguments.}
\usage{
w_datasets(language = "fr", client_ID)
}
\arguments{
\item{language}{Optional. String. Defaults to "fr" (French). The only other available option is "en" (English). Determines the language of the metadata. Your Webstat "App" must be subscribed to the API in this language or you'll get a 501 http error.}

\item{client_ID}{Optional. String. If you do not specify it when calling the function, it will check if a global variable called ".GlobalEnv$webstat_client_ID exists and use it. If not, you will be prompted. The easiest way is to save the client ID as a string in ".GlobalEnv$webstat_client_ID".}
}
\value{
A data frame containing the dataset codes and datasets names
}
\description{
List all the available datasets from Webstat (codes and names) in a table. No arguments.
}
\section{Identification}{

You should declare your Webstat client ID in a global "webstat_client_ID" variable. Alternatively, you can enter your client ID as a parameter or enter it when prompted.
}

\examples{
\donttest{
## Request the dataset catalogue
w_datasets()

## Request the dataset catalogue, in English
w_datasets(language = "en")

\dontrun{
## Your client ID can be entered as a parameter as follows or saved
## in a global variable named "webstat_client_ID" in order to reuse it.
w_datasets(client_ID = "1234abcd-12ab-12ab-12ab-123456abcdef") 
}
}

}
