% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlist_rv.R
\name{unlistrv}
\alias{unlistrv}
\title{Flatten Lists Containing rv Objects}
\usage{
unlistrv(x, recursive = TRUE, use.names = TRUE)
}
\arguments{
\item{x}{An R object, typically a list or vector (containing rv objects)}

\item{recursive}{logical. Should unlisting be applied to list components of
x?}

\item{use.names}{logical. Should names be preserved? (now fixed to TRUE)}
}
\description{
Given a list structure \code{x}, \code{unlist} simplifies it to produce a
vector which contains all the atomic components (\emph{containing rv
objects}) which occur in \code{x}.
}
\details{
This is the rv-compatible version of the function \code{\link{unlist}}.

Since \code{unlist} is not a generic function, the whole name
\code{unlistrv} must be specified when calling the function when \code{x} is
an 'rv' object.
}
\examples{

  x <- list(a=rvnorm(2), b=rvnorm(3))
  print(unlistrv(x))

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{unlist}}
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{manip}
