% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvsd_rvvar.R
\name{rvvar}
\alias{rvvar}
\alias{rvsd}
\alias{rvsd.rv}
\alias{rvsd.rvsummary}
\alias{rvvar.rv}
\alias{rvvar.rvsummary}
\title{Variances of Components of Random Vectors}
\usage{
rvvar(x)
}
\arguments{
\item{x}{an object}
}
\value{
A numeric vector or array (of the same dimension as that of
\code{x})
}
\description{
Computes variances of the simulations of components of a random vector of
array.
}
\details{
\code{rvvar} computes the means of the simulations of all individual
components of a random vector (rv) object.

That is, \code{rvvar} applies the function \code{var} to the vector of
simulations of each component of \code{x}, thus computing "columnwise"
variances of the matrix of simulations of \code{x}.

\code{rvsd} applies the function \code{sd} to the vector of simulations of
each component of \code{x}, thus computing "columnwise" standard deviations
of the matrix of simulations of \code{x}.
}
\examples{

  x <- rvnorm(mean=0, var=1:10)
  rvvar(x)
  rvsd(x)

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{rvmin}}, \code{\link{rvmax}}, \code{\link{rvmedian}},
\code{\link{rvsd}}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
