% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvattr.R
\name{rvattr}
\alias{rvattr}
\alias{rvattr<-}
\title{Attributes of Random Variables}
\usage{
rvattr(x, attrib = NULL)

rvattr(x, attrib = NULL, by.name = FALSE) <- value
}
\arguments{
\item{x}{an object}

\item{attrib}{name of the attribute}

\item{by.name}{logical; attempt matching of attributes by name?}

\item{value}{vector of values to set; can be a list or an atomic vector}
}
\description{
\code{rvattr}
}
\details{
If \code{by.name=TRUE}, the values within the list \code{value} are matched
by their name (e.g. `\code{theta[1]}') if possible.  Matching by \code{NA}
or the empty string in a name is not possible.

Otherwise, the list is matched by position; in this case, the length of
\code{value} must be equal to that of \code{x}.
}
\examples{

  ##

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
