% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvdirichlet.R
\name{rvdirichlet}
\alias{rvdirichlet}
\title{Generate Random Variables from a Dirichlet Sampling Model}
\usage{
rvdirichlet(n = 1, alpha)
}
\arguments{
\item{n}{integer: number of vectors to generate}

\item{alpha}{the parameter vector; may be random}
}
\value{
A random vector (rv object) of length \code{n}.
}
\description{
Generates random variables from a Dirichlet sampling model.
}
\details{
The Dirichlet distribution is a generalization of the Beta distribution.
(If alpha is of length two, \code{rvdirichlet} draws from the Beta model.)
}
\examples{
\dontrun{

  a <- rvdirichlet(1, alpha=c(6, 3, 1)) # 
  sum(a) # one with probability 1   
  }

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
