% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder.R, R/autoencoder_variational.R
\name{to_keras.ruta_autoencoder}
\alias{to_keras.ruta_autoencoder}
\alias{to_keras.ruta_autoencoder_variational}
\title{Extract Keras models from an autoencoder wrapper}
\usage{
\method{to_keras}{ruta_autoencoder}(learner, encoder_end = "encoding",
  decoder_start = "encoding", weights_file = NULL)

\method{to_keras}{ruta_autoencoder_variational}(learner, ...)
}
\arguments{
\item{learner}{Object of class \code{"ruta_autoencoder"}. Needs to have a member
\code{input_shape} indicating the number of attributes of the input data}

\item{encoder_end}{Name of the Keras layer where the encoder ends}

\item{decoder_start}{Name of the Keras layer where the decoder starts}

\item{weights_file}{The name of a hdf5 weights file in order to load from a trained model}

\item{...}{Additional parameters for \code{to_keras.ruta_autoencoder}}
}
\value{
A list with several Keras models:
\itemize{
\item \code{autoencoder}: model from the input layer to the output layer
\item \code{encoder}: model from the input layer to the encoding layer
\item \code{decoder}: model from the encoding layer to the output layer
}
}
\description{
Extract Keras models from an autoencoder wrapper
}
\seealso{
\code{\link{autoencoder}}
}
