% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_example.R
\name{rgpd}
\alias{rgpd}
\title{Generalized Pareto simulation}
\usage{
rgpd(m = 1, sigma = 1, xi = 0)
}
\arguments{
\item{m}{A numeric scalar.  The size of sample required.}

\item{sigma}{A numeric scalar.  The generalized Pareto scale parameter
\eqn{\sigma}.}

\item{xi}{A numeric scalar.  The generalized Pareto shape parameter
\eqn{\xi}.}
}
\value{
A numeric vector.  A generalized Pareto sample of size \code{m}.
}
\description{
Simulates a sample of size \code{m} from a generalized Pareto distribution.
}
\examples{
\donttest{
# Sample data from a GP(sigma, xi) distribution
gpd_data <- rgpd(m = 100, xi = 0, sigma = 1)
}
}
