% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTrades.R
\name{getTrades}
\alias{getTrades}
\title{Download trades of account}
\usage{
getTrades(
  src = "",
  api.key = "",
  clientId = "",
  figi = "",
  from = Sys.Date() - 5,
  to = Sys.Date(),
  symbol_info = FALSE,
  time_transform = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{src}{Character string indicating the broker to use. Currently, only "tinkoff" and "alor" are supported.}

\item{api.key}{Character string containing the API key for the broker's API.}

\item{clientId}{Character string containing the client ID for the broker.}

\item{figi}{Character string containing the Financial Instrument Global Identifier for the broker.}

\item{from}{Date specifying the start date for the trade data. Defaults to 5 days ago.}

\item{to}{Date specifying the end date for the trade data. Defaults to the current date.}

\item{symbol_info}{Logical indicating whether to include symbol information in the returned data. Defaults to FALSE.}

\item{time_transform}{Logical indicating whether to transform the timestamps to the local timezone. Defaults to TRUE.}

\item{verbose}{Logical indicating whether to print verbose output. Defaults to FALSE.}
}
\value{
A data frame containing the trade data.
}
\description{
Get trades for a given broker from a specified date to the current date.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getTrades(src = "tinkoff", api.key = "tks token", clientId = "clientID", figi = "figi",verbose=TRUE)
}
\author{
Vyacheslav Arbuzov
}
