% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.Finam.R
\name{getSymbols.Finam}
\alias{getSymbols.Finam}
\title{Download historical data from Finam.ru}
\usage{
getSymbols.Finam(
  Symbols,
  env = globalenv(),
  from = "2007-01-01",
  to = Sys.Date(),
  adjust = FALSE,
  period = "day",
  market = NULL,
  verbose = FALSE,
  auto.assign = FALSE,
  api.key = "",
  user_agent = NULL,
  ...
)
}
\arguments{
\item{Symbols}{A character vector of one or more stock symbols.}

\item{env}{The environment where the data should be assigned. Defaults to the global environment.}

\item{from}{The start date for the data. Defaults to "2007-01-01".}

\item{to}{The end date for the data. Defaults to the current date.}

\item{adjust}{A logical indicating whether to adjust for dividends and splits. Defaults to FALSE.}

\item{period}{The interval to use for the data. Must be one of "tick", "1min", "5min", "10min", "15min", "30min", "hour", "day", "week", or "month". Defaults to "day".}

\item{market}{A character vector indicating the market for each symbol. If NULL, the function will attempt to determine the market automatically. Defaults to NULL.}

\item{verbose}{A logical indicating whether to print progress messages. Defaults to FALSE.}

\item{auto.assign}{A logical indicating whether to assign the data to an object with the same name as the symbol. Defaults to FALSE.}

\item{api.key}{character representing the authorization key required for accessing broker/exchange API}

\item{user_agent}{Header for user agent for Finam}

\item{...}{additional arguments passed to getSymbols.Finam}
}
\value{
returns an data.table object containing the requested data with orders of current account.
}
\description{
Download historical data from Finam.ru for one or more stock symbols. The data can be returned as an xts object or assigned to a specified environment. This function uses the Finam.ru export service to retrieve data.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
api_key = 'set_if_use_API'
getSymbols('SBER',src='Finam',api.key = api_key)
}
\author{
Vyacheslav Arbuzov
}
