% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTradelog.R
\name{getTradelog}
\alias{getTradelog}
\title{Get tradelog information from a brokerage or exchange}
\usage{
getTradelog(
  Symbols,
  depth = 500,
  src = "poloniex",
  api.key = "",
  adjust = FALSE,
  return.class = "data.table",
  index.class = "Date",
  verbose = FALSE,
  auto.assign = TRUE,
  env = globalenv()
)
}
\arguments{
\item{Symbols}{Character vector specifying the trading pair, e.g. "BTC_ETH".}

\item{depth}{Numeric scalar, specifying the number of trades to retrieve (default = 500).}

\item{src}{Character scalar, specifying the exchange to retrieve trade logs from. The supported exchanges are: "tinkoff", "alor", "poloniex", "kraken", "binance", "bttrex", "cex", "gate", "gatecoin", "gdax", "gemini", "hitbtc", "liqui", and "lykke".}

\item{api.key}{Character scalar, specifying the API key (if required by the exchange).}

\item{adjust}{Logical scalar, specifying whether to adjust timestamps for time zones (default = FALSE).}

\item{return.class}{Character scalar, specifying the class of the returned object. The supported classes are: "data.table", "data.frame", and "xts" (default = "data.table").}

\item{index.class}{Character scalar, specifying the class of the index column. The supported classes are: "Date" and "POSIXct" (default = "Date").}

\item{verbose}{Logical scalar, specifying whether to print verbose output (default = FALSE).}

\item{auto.assign}{Logical scalar, specifying whether to automatically assign the resulting object to the global environment (default = TRUE).}

\item{env}{environment where data is stored}
}
\value{
A data table or data frame with the retrieved trade logs, depending on the value of the \code{return.class} argument.
}
\description{
This function retrieves account information from a brokerage or exchange.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getTradelog('BTC_USDT', src = 'poloniex')
}
\author{
Vyacheslav Arbuzov
}
