% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fit_xrf.R
\name{details_rule_fit_xrf}
\alias{details_rule_fit_xrf}
\title{RuleFit models via xrf}
\description{
\code{\link[xrf:xrf]{xrf::xrf()}} fits a model that derives simple feature rules from a tree
ensemble and uses them as features to a regularized model. \code{\link[=xrf_fit]{xrf_fit()}}
is a wrapper around this function.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 8 tuning parameters:
\itemize{
\item \code{mtry}: Proportion Randomly Selected Predictors (type: double,
default: 1.0)
\item \code{trees}: # Trees (type: integer, default: 15L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 1L)
\item \code{tree_depth}: Tree Depth (type: integer, default: 6L)
\item \code{learn_rate}: Learning Rate (type: double, default: 0.3)
\item \code{loss_reduction}: Minimum Loss Reduction (type: double, default:
0.0)
\item \code{sample_size}: Proportion Observations Sampled (type: double,
default: 1.0)
\item \code{penalty}: Amount of Regularization (type: double, default: 0.1)
}
}

\subsection{Translation from parsnip to the underlying model call (regression)}{\if{html}{\out{<div class="r">}}\preformatted{rule_fit(
  mtry = numeric(1),
  trees = integer(1),
  min_n = integer(1),
  tree_depth = integer(1),
  learn_rate = numeric(1),
  loss_reduction = numeric(1),
  sample_size = numeric(1),
  penalty = numeric(1)
) \%>\%
  set_engine("xrf") \%>\%
  set_mode("regression") \%>\%
  translate()
}\if{html}{\out{</div>}}\preformatted{## RuleFit Model Specification (regression)
## 
## Main Arguments:
##   mtry = numeric(1)
##   trees = integer(1)
##   min_n = integer(1)
##   tree_depth = integer(1)
##   learn_rate = numeric(1)
##   loss_reduction = numeric(1)
##   sample_size = numeric(1)
##   penalty = numeric(1)
## 
## Computational engine: xrf 
## 
## Model fit template:
## rules::xrf_fit(object = missing_arg(), data = missing_arg(), 
##     colsample_bytree = numeric(1), nrounds = integer(1), min_child_weight = integer(1), 
##     max_depth = integer(1), eta = numeric(1), gamma = numeric(1), 
##     subsample = numeric(1), lambda = numeric(1))
}
}

\subsection{Translation from parsnip to the underlying model call (classification)}{\if{html}{\out{<div class="r">}}\preformatted{rule_fit(
  mtry = numeric(1),
  trees = integer(1),
  min_n = integer(1),
  tree_depth = integer(1),
  learn_rate = numeric(1),
  loss_reduction = numeric(1),
  sample_size = numeric(1),
  penalty = numeric(1)
) \%>\%
  set_engine("xrf") \%>\%
  set_mode("classification") \%>\%
  translate()
}\if{html}{\out{</div>}}\preformatted{## RuleFit Model Specification (classification)
## 
## Main Arguments:
##   mtry = numeric(1)
##   trees = integer(1)
##   min_n = integer(1)
##   tree_depth = integer(1)
##   learn_rate = numeric(1)
##   loss_reduction = numeric(1)
##   sample_size = numeric(1)
##   penalty = numeric(1)
## 
## Computational engine: xrf 
## 
## Model fit template:
## rules::xrf_fit(object = missing_arg(), data = missing_arg(), 
##     colsample_bytree = numeric(1), nrounds = integer(1), min_child_weight = integer(1), 
##     max_depth = integer(1), eta = numeric(1), gamma = numeric(1), 
##     subsample = numeric(1), lambda = numeric(1))
}
}

\subsection{Differences from the xrf package}{

Note that, per the documentation in \code{?xrf}, transformations of the
response variable are not supported. To use these with \code{rule_fit()}, we
recommend using a recipe instead of the formula method.

Also, there are several configuration differences in how \code{xrf()} is fit
between that package and the wrapper used in \code{rules}. Some differences
in default values are:
\itemize{
\item \code{trees}: \verb{xrf: 100,}rules`: 15
\item \code{max_depth}: \code{xrf}: 3, \code{rules}: 6
}

These differences will create a difference in the values of the
\code{penalty} argument that \code{glmnet} uses. Also, can also set \code{penalty}
whereas uses an internal 5-fold cross-validation to determine it (by
default).
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via
\code{\link[=fit.model_spec]{fit.model_spec()}}, parsnip will
convert factor columns to indicators.
}

\subsection{References}{
\itemize{
\item Friedman and Popescu. “Predictive learning via rule ensembles.” Ann.
Appl. Stat. 2 (3) 916- 954, September 2008
}
}
}
\keyword{internal}
