% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure.R
\name{packs_info}
\alias{packs_info}
\alias{is_packs_info}
\alias{get_packs_info}
\title{Packs info}
\usage{
is_packs_info(.x, .skip_class = FALSE)

get_packs_info(.object)
}
\arguments{
\item{.x}{Object to test.}

\item{.skip_class}{Whether to skip checking inheritance from \code{packs_info}.}

\item{.object}{Object to get \code{packs_info} value from \code{exposure} attribute.}
}
\value{
\code{get_packs_info()} returns \code{packs_info} attribute of \code{object} if it
is exposure and of its 'exposure' attribute otherwise.
}
\description{
An S3 class \code{packs_info} to represent information about packs in \link{exposure}.
It is a tibble with the following structure:
\itemize{
\item \strong{name} \verb{<chr>} : Name of the pack.
\item \strong{type} \verb{<chr>} : \link[=rule-packs]{Pack type}.
\item \strong{fun} \verb{<list>} : List (preferably unnamed) of rule pack functions.
\item \strong{remove_obeyers} \verb{<lgl>} : value of \code{.remove_obeyers} argument of
\code{\link[=expose]{expose()}} with which pack was applied.
}
}
\details{
To avoid possible confusion it is preferred (but not required) that
list-column \code{fun} doesn't have names. Names of packs are stored in \code{name}
column. During \link[=expose]{exposure} \code{fun} is always created without names.
}
\examples{
my_row_packs <- row_packs(
  row_mean_props = . \%>\% dplyr::transmute(row_mean = rowMeans(.)) \%>\%
    dplyr::transmute(
      row_mean_low = row_mean > 20,
      row_mean_high = row_mean < 60
    ),
  row_outlier = . \%>\% dplyr::transmute(row_sum = rowSums(.)) \%>\%
    dplyr::transmute(
      not_row_outlier = abs(row_sum - mean(row_sum)) / sd(row_sum) < 1.5
    )
)
my_data_packs <- data_packs(
  data_dims = . \%>\% dplyr::summarise(
    nrow = nrow(.) == 32,
    ncol = ncol(.) == 5
  )
)

mtcars_exposed <- mtcars \%>\%
  expose(my_data_packs, .remove_obeyers = FALSE) \%>\%
  expose(my_row_packs)

mtcars_exposed \%>\% get_packs_info()

mtcars_exposed \%>\%
  get_packs_info() \%>\%
  is_packs_info()
}
