% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{act_after_exposure}
\alias{act_after_exposure}
\title{Act after exposure}
\usage{
act_after_exposure(.tbl, .trigger, .actor)
}
\arguments{
\item{.tbl}{Result of \link[=expose]{exposure}, i.e. data frame with \link{exposure}
attribute.}

\item{.trigger}{Function which takes \code{.tbl} as argument and returns \code{TRUE} if
some action needs to be performed.}

\item{.actor}{Function which takes \code{.tbl} as argument and performs the
action.}
}
\description{
A wrapper for consistent application of some actions based on the data after
exposure.
}
\details{
Basically \code{act_after_exposure()} is doing the following:
\itemize{
\item Check that \code{.tbl} has a proper \link{exposure} attribute.
\item Compute whether to perform intended action by computing \code{.trigger(.tbl)}.
\item If trigger results in \code{TRUE} then \code{.actor(.tbl)} \strong{is returned}. In other
case \code{.tbl} is returned.
}

It is a good idea that \code{.actor} should be doing one of two things:
\itemize{
\item Making side effects. For example throwing an error (if condition in
\code{.trigger} is not met), printing some information and so on. In this case it
should return \code{.tbl} to be used properly inside a \link[magrittr:pipe]{pipe}.
\item Changing \code{.tbl} based on exposure information. In this case it should
return the imputed version of \code{.tbl}.
}
}
\examples{
exposure_printer <- function(.tbl) {print(get_exposure(.tbl)); .tbl}
mtcars_exposed <- mtcars \%>\%
  expose(data_packs(. \%>\% dplyr::summarise(nrow_low = nrow(.) > 50))) \%>\%
  act_after_exposure(any_breaker, exposure_printer)

}
\seealso{
\link{any_breaker} for trigger which returns \code{TRUE} in case any rule
breaker is found in exposure.

\link{assert_any_breaker} for usage of \code{act_after_exposure()} in building data
validation pipelines.
}
