% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ucm.R
\name{predict.ucm}
\alias{predict.ucm}
\title{Unobserved Components Model Predictions}
\usage{
\method{predict}{ucm}(object, n.ahead, newdata, ...)
}
\arguments{
\item{object}{an object of class \code{SSModel} which can be retrieved from \code{$model} call of an object of class \code{ucm}.}

\item{n.ahead}{number of points for which forecasts are to generated.}

\item{newdata}{dataset for which prediction is to be made.}

\item{\dots}{ignored.}
}
\value{
A matrix or list of matrices containing the predictions.
}
\description{
Function \code{predict.ucm} predicts the future observations of an Unobserved Components Model. The \code{ucm} function returns an object \code{model} of class \code{SSModel} which is then further used in \code{predict.SSModel}.
}
\examples{
modelNile <- ucm(Nile~0, data = Nile, slope = TRUE)
predict(modelNile$model, n.ahead = 12)

}
\seealso{
\code{\link{predict.SSModel}}.
}

