% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{users_data}
\alias{users_data}
\alias{user_data}
\alias{data_user}
\alias{data_users}
\title{Extracts users data from tweets data object.}
\usage{
users_data(tweets)
}
\arguments{
\item{tweets}{Parsed data object of tweets data as returned via
\code{\link{get_timeline}}, \code{\link{search_tweets}},
\code{\link{stream_tweets}}, etc..}
}
\value{
Users data frame from tweets returned in a tweets data object.
}
\description{
Extracts users data from tweets data object.
}
\examples{

\dontrun{

## search for 100 tweets containing the letter r
r <- search_tweets("r")

## print tweets data (only first 10 rows are shown)
head(r, 10)

## extract users data
head(users_data(r))

}

}
\seealso{
Other users: \code{\link{as_screenname}},
  \code{\link{lists_subscribers}},
  \code{\link{lookup_users}}, \code{\link{search_users}},
  \code{\link{tweets_with_users}}

Other extractors: \code{\link{next_cursor}},
  \code{\link{tweets_data}}
}
\concept{extractors}
\concept{users}
