% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtsplot.r
\name{rtsplot2Y}
\alias{rtsplot2Y}
\title{Plot time series with second Y axis}
\usage{
rtsplot2Y(y, las = 1, type = "l", ...)
}
\arguments{
\item{y}{\code{\link{xts}} object}

\item{las}{rotation of Y axis labels, \strong{defaults to 1}, for more info see \code{\link{par}}}

\item{type}{plot type, \strong{defaults to 'l'}, for more info see \code{\link{plot}}
also support 'ohlc', 'hl', 'candle', 'volume' types}

\item{...}{additional parameters to the \code{\link{plot}}}
}
\value{
nothing
}
\description{
Plot time series with second Y axis
}
\examples{
# generate time series data
n = 1000
x =  seq(Sys.Date(), by = 'day', length.out = n)
y = cumsum( rnorm(n, sd = sqrt(0.1)) )
y = xts::xts(y, x)
symbol = 'SPY'

y1 = 100 + cumsum( rnorm(n, sd = sqrt(0.1)) )
y1 = xts::xts(y1, x)
symbol = 'IBM'
	
# two Y axis example
# to plot second Y axis, free some space on left side, set LeftMargin=3
layout(1)
cols = c('black', 'red')

rtsplot(y, type = 'l', LeftMargin=3, col=cols[1])
			
rtsplot2Y(y1, type='l', las=1, col=cols[2], col.axis=cols[2])

rtsplot.legend('SPY(rhs),IBM(lhs)', cols, list(y,y1))
}
