% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_col.R
\name{rtry_remove_col}
\alias{rtry_remove_col}
\title{Remove columns}
\usage{
rtry_remove_col(input, ..., showOverview = TRUE)
}
\arguments{
\item{input}{Input data frame or data table.}

\item{\dots}{Names of columns to be removed separated by commas. The operator \code{:}
can be used for selecting a range of consecutive variables.}

\item{showOverview}{Default \code{TRUE} displays the dimension of the remaining data.}
}
\value{
An object of the same type as the input data.
}
\description{
This function removes specified columns from the imported data for further processing.
}
\examples{
# Remove certain columns from the provided sample data (data_TRY_15160)
data_rm_col <- rtry_remove_col(data_TRY_15160,
                 LastName, FirstName, DatasetID, Dataset, SpeciesName,
                 OrigUncertaintyStr, UncertaintyName, Replicates,
                 RelUncertaintyPercent, Reference, V28)

# Expected message:
# dim:   1782 17
# col:   AccSpeciesID AccSpeciesName ObservationID ObsDataID TraitID TraitName
#        DataID DataName OriglName OrigValueStr OrigUnitStr ValueKindName
#        StdValue UnitName OrigObsDataID ErrorRisk Comment
}
\references{
This function makes use of the \code{\link[dplyr]{select}} function
within the \code{dplyr} package.
}
\seealso{
\code{\link{rtry_select_col}}
}
