% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_index.R
\name{plot.trim.index}
\alias{plot.trim.index}
\title{Plot time-indices from trim output}
\usage{
\method{plot}{trim.index}(x, covar = "auto", ...)
}
\arguments{
\item{x}{an object of class \code{trim.index}, as resulting from e.g. a call to \code{\link{index}}.}

\item{covar}{\code{[character]} the name of a covariate to include in the plot.
If set to \code{"auto"} (the default), the first (or only) covariate is used.
If set to \code{"none"} plotting of covariates is suppressed and only the overall index is shown.}

\item{...}{Further options passed to \code{\link[graphics]{plot}}}
}
\description{
Plot time-indices from trim output
}
\examples{

data(skylark)
z <- trim(count ~ site + time + Habitat, data=skylark, model=2)
idx <- index(z, covars=TRUE)
plot(idx, covar="Habitat", main="Skylark")

}
\seealso{
Other analyses: \code{\link{coef.trim}}, \code{\link{gof}},
  \code{\link{index}}, \code{\link{now_what}},
  \code{\link{overall}}, \code{\link{overdispersion}},
  \code{\link{plot.trim.overall}}, \code{\link{results}},
  \code{\link{serial_correlation}},
  \code{\link{summary.trim}}, \code{\link{totals}},
  \code{\link{trim}}, \code{\link{vcov.trim}},
  \code{\link{wald}}
}

