% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instances.R
\name{get_instance}
\alias{get_instance}
\alias{get_instance_general}
\alias{get_instance_peers}
\alias{get_instance_activity}
\alias{get_instance_emoji}
\alias{get_instance_directory}
\alias{get_instance_trends}
\alias{get_instance_rules}
\alias{get_instance_blocks}
\title{Get various information about a specific instance}
\usage{
get_instance_general(instance = NULL, token = NULL, anonymous = TRUE)

get_instance_peers(instance = NULL, token = NULL, anonymous = TRUE)

get_instance_activity(instance = NULL, token = NULL, anonymous = TRUE)

get_instance_emoji(instance = NULL, token = NULL, anonymous = TRUE)

get_instance_directory(
  instance = NULL,
  token = NULL,
  offset = 0,
  limit = 40,
  order = "active",
  local = FALSE,
  anonymous = TRUE,
  parse = TRUE
)

get_instance_trends(
  instance = NULL,
  token = NULL,
  limit = 10,
  anonymous = TRUE
)

get_instance_rules(instance = NULL, token = NULL, anonymous = FALSE)

get_instance_blocks(instance = NULL, token = NULL, anonymous = TRUE)
}
\arguments{
\item{instance}{character, the server name of the instance where the status is located. If \code{NULL}, the same instance used to obtain the token is used.}

\item{token}{user bearer token (read from file by default)}

\item{anonymous}{logical, should the API call be made anonymously? Defaults to TRUE but some instances might need authentication here}

\item{offset}{How many accounts to skip before returning results. Default 0.}

\item{limit}{integer, Maximum number of results to return}

\item{order}{'active' to sort by most recently posted statuses (default) or 'new' to sort by most recently created profiles.}

\item{local}{logical, show only local accounts?}

\item{parse}{logical, if \code{TRUE}, the default, returns a tibble. Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API.}
}
\value{
instance details as list or tibble depending on call function
}
\description{
Get various information about a specific instance
}
\details{
\describe{
\item{get_instance_general}{Returns general information about the instance}
\item{get_instance_peers}{Returns the peers of an instance}
\item{get_instance_activity}{Shows the weekly activity of the instance (3 months)}
\item{get_instance_emoji}{Lists custom emojis available on the instance}
\item{get_instance_directory}{A directory of profiles that the instance is aware of}
\item{get_instance_trends}{Tags that are being used more frequently within the past week}
\item{get_instance_rules}{Prints the rules of an instance}
\item{get_instance_blocks}{List of domains that are blocked by an instance.}
}
}
\examples{
\dontrun{
 get_instance_general("mastodon.social")
 get_instance_activity("mastodon.social")
 get_instance_emoji("mastodon.social")
 get_instance_peers("mastodon.social")
 get_instance_directory("mastodon.social",limit = 2)
}
}
