% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testTIP.R
\name{testTIP}
\alias{testTIP}
\title{Test for TIP dominance}
\usage{
testTIP(dataset1, dataset2, pz = 0.6, same.arpt.value = NULL,
  norm = FALSE, samplesize = 50)
}
\arguments{
\item{dataset1}{a data.frame containing variables obtained by using the setupDataset function.}

\item{dataset2}{a data.frame containing variables obtained by using the setupDataset function.}

\item{pz}{a number between 0 and 1 which represents the percentage to be used to calculate the at-risk-of-poverty threshold. The default is 0.6.}

\item{same.arpt.value}{a number that will be used as a common poverty threshold. If NULL, poverty thresholds will be calculated from each datasets (see arpt).}

\item{norm}{logical; if  TRUE, the normalized TIP curve ordinates are computed using the normalized poverty gaps (poverty gaps divided by the poverty threshold).}

\item{samplesize}{an integer which represents the number of TIP curve ordinates to be estimated. The default is 50.}
}
\value{
A list with the following components:
\itemize{
\item Tvalue, the value of the test-statistic.
\item p.value, simulated p-value of the test-statistic Tvalue (Wolak, 1989). It is calculated only when the Tvalue falls into an inconclusive region.
\item decision, if the Tvalue is less than the lower-bound of the critical value at the 5 percent significance level the decision is "Do not reject null hypothesis".
If the Tvalue is greater than the upper-bound of the critical value at the 5 percent significance level the decision is "Reject null hypothesis". Lower and upper-bounds
critical values are obtained from Kodde and Palm (1986). If Tvalue falls into an inconclusive region (between the lower- and upper-bounds) the p-value will
be estimated following Wolak (1989).
}
}
\description{
Statistical test procedure given by Xu and Osberg (1998) to study TIP dominance from sample
TIP curve estimates.
}
\details{
Because the TIP curve becomes horizontal at the arpr value, it is only necessary to have the test implemented over the interval \eqn{(0, \max \{ arpr1, arpr2 \})}{(0, max {arpr1, arpr2})}. For that reason both TIP curves are truncated at the same value equal to \eqn{\max \{ arpr1, arpr2 \} }{max{arpr1, arpr2}} and ordinates are only compared at points \eqn{p_i = i/samplesize}{p_i = i/samplesize}, where \eqn{i=1, \dots, k} in the interval \eqn{(0, \max \{ arpr1, arpr2 \})}{(0, max { arpr1, arpr2})} (see \code{arpr} function).

The null hypotesis to be tested is that the TIP curve calculated from dataset1 dominates the one calculated from dataset2.
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT")
ATdataset1 <- setupDataset(eusilc2, country = "AT", region = "Burgenland")
ATdataset2 <- setupDataset(eusilc2, country = "AT", region = "Carinthia")
testTIP(ATdataset1, ATdataset, same.arpt.value = arpt(ATdataset))

}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
\references{
C. M. Beach and S. F. Kaliski (1986) Curve inference with sample weights: and application to the distribution of unemployment experience, Journal of the Royal Statistical Society. Series C (Applied Statistics), Vol. 35, No. 1, 38--45.

D.A. Kodde and F.C. Palm (1986) Wald criteria for jointly testing equality and inequality restrictions, Econometrica, 50, 1243--1248.

F.A. Wolak (1989), Testing inequality constrains in linear econometric models, Journal of Econometrics, 41, 205--235.

K. Xu and L. Osberg (1998) A distribution-free test for deprivation dominance, Econometric Reviews, 17, 415--429.
}
\seealso{
OmegaTIP, setupDataset, arpt, arpr
}

