% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_convert.R
\name{batch_convert}
\alias{batch_convert}
\title{Reading several MicroPEM files and saving the settings and measurement tables to csv.}
\usage{
batch_convert(path_input, path_output = path_input)
}
\arguments{
\item{path_input}{path to the directory with files (\code{character})}

\item{path_output}{path where the files should be created, by default equal to \code{path_input} (\code{character}).

The function saves results in the input directory as csv files with a "," as separator.
One file is settings.csv with all settings, the other one is measures.csv
It saves them directly for not loading all of them at the same time in the session.}
}
\description{
Reading several MicroPEM files and saving the settings and measurement tables to csv.
}
\examples{
\dontrun{
batch_convert(path_input = c(system.file('extdata', 'dummyCHAI.csv', package = 'micropem'),
system.file('extdata', 'dummyCHAI.csv', package = 'micropem')),
path_output = getwd())}
}
