% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micropem_class.R
\docType{class}
\name{micropem}
\alias{micropem}
\title{An R6 class to represent MicroPEM output information.}
\format{\code{\link{R6Class}} object.}
\usage{
micropem
}
\value{
Object of \code{\link{R6Class}}.
}
\description{
An R6 class to represent MicroPEM output information.
}
\section{Fields}{

\describe{
\item{\code{settings}}{Data.frame (\code{dplyr "tbl_df"}) with settings of the micropem device and other information such as download time.}

\item{\code{calibration}}{List of calibration information.}

\item{\code{filename}}{Filename from which the oject was built.}

\item{\code{measures}}{Data.frame (\code{dplyr "tbl_df"}) with all time-varying measures, possibly:
\describe{
  \item{datetime}{Time and date of each measurement, as a POSIXt object. Depending on the different logs of the time-varying variables there is not a measure for all variables associated to each timepoint.}
  \item{rh_corrected_nephelometer}{Measures of nephelometer in microgram/meter cube (numeric).}
  \item{temp}{Measures of temperature in centigrade (numeric).}
  \item{rh}{Measures of relative humidity that are a proportion and as such do not have an unit (numeric).}
  \item{battery}{Measures of battery  in Volt (numeric).}
  \item{orifice_press}{Measures of orifice pressure in inches of water (numeric).}
  \item{inlet_press}{Measures of inlet pressure in inches of water (numeric).}
  \item{flow}{Measures of flow in liters per minute (numeric).}
  \item{x_axis}{x-axis accelerometer in m/s2 (numeric).}
  \item{y_axis}{y-axis accelerometer in m/s2 (numeric).}
  \item{z_axis}{z-axis accelerometer in m/s2 (numeric).}
  \item{vector_sum_composite}{vector sum m/s2 (numeric).}
  \item{message}{Shutdown reason (factor).}
  }}

\item{\code{original}}{Boolean. Is this an original micropem object (TRUE) or was it e.g. filtered or cleaned (FALSE).}
}}

\section{Methods}{

\describe{
  \item{plot}{Method for getting a quick plot of all time-varying measurements.
  Either \code{type ="plain"} or \code{type ="interactive"}, see examples.
  The method returns a plot of the \code{ggplot}-class. One can add a title via the \code{title} argument.}
  \item{summary}{Method for getting a summary table (\code{dplyr "tbl_df"}) of all time-varying numeric measurements.}
  \item{print}{Method for printing both the summary table of all time-varying numeric measurements and all settings from the \code{settings} field.}
  }
}

\examples{
data("micropemChai")
# Plot method, type = "plain" by default.
micropemChai$plot()
# Example with type = "interactive", for RStudio viewer,
# RMardown html documents and Shiny apps.
\dontrun{
library("rbokeh")
p <- micropemChai$plot(type = "interactive")
p
# Summary method
micropemChai$summary()
# Print method
micropemChai$print()
}
}
\keyword{data}
