/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.converters.GenericDataTable;
import org.vikamine.kernel.data.creators.DBConnector;

public class DBDataTableCreator {
    private DBConnector dbo;
    private String TableName;
    private int size;
    private ResultSet resultset;
    private GenericDataTable dt;
    private ArrayList<String> hList;

    public DBDataTableCreator(DBConnector dbo, String s) {
        this.dbo = dbo;
        this.TableName = s;
    }

    public DBDataTableCreator(ResultSet resultset, ArrayList<String> headlist) {
        this.resultset = resultset;
        this.hList = headlist;
    }

    private List<String> collectHeader() {
        if (this.hList != null) {
            this.size = this.hList.size();
            return this.hList;
        }
        ArrayList<String> headList = new ArrayList<String>();
        ResultSet rs = this.dbo.showColums(this.TableName);
        try {
            while (rs.next()) {
                headList.add(rs.getString(1));
            }
        }
        catch (Exception iea) {
            iea.printStackTrace();
        }
        this.size = headList.size();
        return headList;
    }

    private void createGenericDataTable() {
        List<String> headers = this.collectHeader();
        if (this.dbo != null) {
            this.resultset = this.dbo.getValues(this.TableName);
        }
        ArrayList<String[]> resultSetRows = new ArrayList<String[]>();
        int rowCount = 0;
        try {
            while (this.resultset.next()) {
                String[] row = new String[this.size];
                int index = 1;
                while (index <= this.size) {
                    String s = this.resultset.getString(index);
                    if (s == null || s.equals("null")) {
                        s = "?";
                    } else if (s.contains("e+")) {
                        s = Double.toString(Double.parseDouble(s));
                    }
                    row[index - 1] = s;
                    ++index;
                }
                resultSetRows.add(row);
                ++rowCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int rowIndex = 0;
        this.dt = new GenericDataTable(rowCount, this.size, true);
        this.dt.setHeader(headers.toArray(new String[0]));
        for (String[] row : resultSetRows) {
            this.dt.setRow(rowIndex, row);
            ++rowIndex;
        }
    }

    public GenericDataTable getTable() {
        this.createGenericDataTable();
        return this.dt;
    }
}

