/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TrieNode
extends AbstractMap
implements Comparable,
Map.Entry {
    private TrieNode parent;
    private List children;
    private Object value;
    private char key = '\u0000';
    private boolean hasValue = false;
    private int size = 0;

    public TrieNode() {
    }

    public TrieNode(char nodeKey) {
        this.setKey(nodeKey);
    }

    public TrieNode(char nodeKey, Object nodeValue) {
        this.setKey(nodeKey);
        this.setValue(nodeValue);
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public Object getValue() {
        return this.value;
    }

    public Object setValue(Object data) {
        boolean oldHasValue = this.hasValue();
        Object old = this.getValue();
        this.value = data;
        this.hasValue = true;
        if (!oldHasValue) {
            this.incrementSize();
        }
        return old;
    }

    public void removeValue() {
        boolean oldHasValue = this.hasValue();
        this.value = null;
        this.hasValue = false;
        if (oldHasValue) {
            this.decrementSize();
        }
    }

    public TrieNode getParent() {
        return this.parent;
    }

    public void setParent(TrieNode parent) {
        this.parent = parent;
    }

    public char getNodeKey() {
        return this.key;
    }

    public Object getKey() {
        return this.getKeyBuffer().toString();
    }

    protected StringBuffer getKeyBuffer() {
        StringBuffer b = this.getParent() != null ? this.getParent().getKeyBuffer() : new StringBuffer();
        if (this.getNodeKey() != '\u0000') {
            b.append(this.getNodeKey());
        }
        return b;
    }

    public void setKey(char key) {
        this.key = key;
    }

    public Object removeChild(String childKeys) {
        TrieNode node = this.getNode(childKeys, false);
        if (node == null) {
            return null;
        }
        Object old = node.getValue();
        node.removeValue();
        if (!node.hasChildren() && node.getParent() != null) {
            node.getParent().removeChild(node);
        }
        return old;
    }

    protected boolean removeChild(TrieNode node) {
        boolean removed = this.getChildren().remove(node);
        if (removed) {
            node.setParent(null);
        }
        if (!this.hasValue() && !this.hasChildren() && this.getParent() != null) {
            this.getParent().removeChild(this);
        }
        return removed;
    }

    public boolean hasChildren() {
        return this.getChildren() != null && !this.getChildren().isEmpty();
    }

    public int compareTo(Object o) {
        return this.getNodeKey() - ((TrieNode)o).getNodeKey();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TrieNode t = (TrieNode)obj;
        return this.getNodeKey() == t.getNodeKey();
    }

    @Override
    public int hashCode() {
        return this.getNodeKey();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getNodeKey()) + ": " + this.getValue();
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public TrieNode getNode(String childKey, boolean createIfNotExists) {
        if (childKey.length() == 0) {
            return this;
        }
        TrieNode node = this.getChild(childKey.charAt(0), createIfNotExists);
        if (node == null) {
            return null;
        }
        return node.getNode(childKey.substring(1), createIfNotExists);
    }

    @Override
    public Object get(Object keyString) {
        String k = (String)keyString;
        TrieNode node = this.getNode(k, false);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    @Override
    public Object put(Object keyString, Object valueObject) {
        String k = (String)keyString;
        TrieNode node = this.getNode(k, true);
        Object old = node.getValue();
        node.setValue(valueObject);
        return old;
    }

    public TrieNode getChild(char childKey, boolean createIfNotExists) {
        int pos;
        TrieNode node = new TrieNode(childKey);
        if (this.getChildren() == null) {
            if (!createIfNotExists) {
                return null;
            }
            this.setChildren(new ArrayList());
        }
        if ((pos = Collections.binarySearch(this.getChildren(), node)) < 0) {
            if (!createIfNotExists) {
                return null;
            }
            pos = -pos - 1;
            this.getChildren().add(pos, node);
            node.setParent(this);
            return node;
        }
        return (TrieNode)this.getChildren().get(pos);
    }

    protected void incrementSize() {
        ++this.size;
        if (this.getParent() != null) {
            this.getParent().incrementSize();
        }
    }

    protected void decrementSize() {
        --this.size;
        if (this.getParent() != null) {
            this.getParent().decrementSize();
        }
    }

    @Override
    public Set entrySet() {
        return new TrieEntrySet();
    }

    @Override
    public boolean containsKey(Object keyString) {
        String k = (String)keyString;
        TrieNode node = this.getNode(k, false);
        return node != null && node.hasValue();
    }

    @Override
    public Object remove(Object keyString) {
        String k = (String)keyString;
        TrieNode node = this.getNode(k, false);
        if (node == null) {
            return null;
        }
        Object old = node.getValue();
        node.removeValue();
        return old;
    }

    class NodeIterator
    implements Iterator {
        boolean returned = false;

        NodeIterator() {
        }

        @Override
        public void remove() {
            if (!this.returned) {
                throw new NoSuchElementException("must call add before remove");
            }
            TrieNode.this.removeValue();
        }

        @Override
        public boolean hasNext() {
            return TrieNode.this.hasValue() && !this.returned;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more elements");
            }
            this.returned = true;
            return TrieNode.this;
        }
    }

    class TrieEntrySet
    extends AbstractSet {
        TrieEntrySet() {
        }

        @Override
        public int size() {
            return TrieNode.this.size;
        }

        @Override
        public Iterator iterator() {
            return new TrieIterator();
        }
    }

    class TrieIterator
    implements Iterator {
        private Iterator childIterator;
        private TrieNode nextEntry;
        private TrieNode previousEntry;
        private int childIndex = 0;
        private boolean hasNext;

        TrieIterator() {
            this.childIterator = new NodeIterator();
            this.prepareNext();
        }

        @Override
        public void remove() {
            if (this.previousEntry == null) {
                throw new NoSuchElementException("must call next before remove");
            }
            this.previousEntry.removeValue();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more elements");
            }
            this.previousEntry = this.nextEntry;
            this.prepareNext();
            return this.previousEntry;
        }

        private void prepareNext() {
            if (!this.childIterator.hasNext()) {
                this.nextIterator();
            }
            if (this.childIterator.hasNext()) {
                this.nextEntry = (TrieNode)this.childIterator.next();
                this.hasNext = true;
            } else {
                this.hasNext = false;
            }
        }

        private void nextIterator() {
            while (TrieNode.this.hasChildren() && this.childIndex < TrieNode.this.getChildren().size() && !this.childIterator.hasNext()) {
                TrieNode nextNode = (TrieNode)TrieNode.this.getChildren().get(this.childIndex);
                this.childIterator = nextNode.entrySet().iterator();
                ++this.childIndex;
            }
        }
    }
}

