/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import java.util.Iterator;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.FilteringDataRecordIterator;
import org.vikamine.kernel.data.IncludingDataRecordFilter;
import org.vikamine.kernel.subgroup.ISubgroup;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsBuilder;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.util.VKMUtil;

public final class SG
implements Cloneable,
ISubgroup<DataRecord> {
    private DataView population;
    private SGTarget target;
    private SGDescription sGDescription;
    private double quality = 0.0;
    private SGStatistics statistics;

    private SG() {
    }

    public SG(DataView population, SGTarget target) {
        this();
        this.population = population;
        this.target = target;
        this.sGDescription = new SGDescription();
    }

    public SG(DataView population, SGTarget target, SGDescription sGDescription) {
        this();
        this.population = population;
        this.target = target;
        this.sGDescription = sGDescription;
    }

    public Object clone() {
        try {
            SG clonedSG = (SG)super.clone();
            clonedSG.sGDescription = this.sGDescription.clone();
            return clonedSG;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Assertion failure!");
        }
    }

    public SG deepCopy() {
        SG clonedSubgroup = (SG)this.clone();
        clonedSubgroup.setSGDescription(clonedSubgroup.getSGDescription().deepCopy());
        if (this.getStatistics() != null) {
            clonedSubgroup.createStatistics(this.getStatistics().getOptions());
        }
        return clonedSubgroup;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SG otherSG = (SG)other;
        return this.equalObjects(this.getTarget(), otherSG.getTarget()) && this.equalObjects(this.getSGDescription(), otherSG.getSGDescription());
    }

    public int hashCode() {
        int hash = 17;
        if (this.sGDescription != null) {
            hash = 37 * hash + this.sGDescription.hashCode();
        }
        if (this.target != null) {
            hash = 37 * hash + this.target.hashCode();
        }
        return hash;
    }

    private boolean equalObjects(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public SGDescription getSGDescription() {
        return this.sGDescription;
    }

    public void setSGDescription(SGDescription description) {
        this.sGDescription = description;
    }

    public SGTarget getTarget() {
        return this.target;
    }

    public void setTarget(SGTarget object) {
        this.target = object;
    }

    @Override
    public double getQuality() {
        return this.quality;
    }

    public void setQuality(double d) {
        this.quality = d;
    }

    public void updateQuality(IQualityFunction qf) {
        this.setQuality(qf.evaluate(this));
    }

    public String toString() {
        return "SG(" + VKMUtil.getFormattedDoubleString(this.quality, 2) + ") " + this.target + " <= " + this.sGDescription;
    }

    public Iterator<DataRecord> subgroupInstanceIterator() {
        if (this.sGDescription.isEmpty()) {
            return this.population.instanceIterator();
        }
        return new FilteringDataRecordIterator(this.population.instanceIterator(), new IncludingDataRecordFilter(){

            @Override
            public boolean isIncluded(DataRecord instance) {
                if (!SG.this.sGDescription.isMatching(instance)) {
                    return false;
                }
                if (SG.this.getTarget() == null) {
                    return true;
                }
                if (SG.this.getStatistics() == null) {
                    return true;
                }
                return SG.this.getStatistics().isTargetDefinedInInstance(SG.this.getTarget(), instance);
            }
        });
    }

    public SGStatistics getStatistics() {
        return this.statistics;
    }

    public void createStatistics() {
        this.createStatistics(null);
    }

    public void createStatistics(Options constraints) {
        this.setStatistics(SGStatisticsBuilder.buildSGStatisticsWithCalculation(this, constraints));
    }

    public void setStatistics(SGStatistics subgroupStatistics) {
        this.statistics = subgroupStatistics;
    }

    public DataView getPopulation() {
        return this.population;
    }

    public void setPopulation(DataView population) {
        this.population = population;
    }

    public static String verbalizeSGAsPrologLikeRule(SG sg) {
        StringBuffer buffy = new StringBuffer();
        if (sg.getTarget() != null) {
            buffy.append(sg.getTarget().getDescription());
        } else {
            buffy.append("<No TV>");
        }
        if (sg.getSGDescription() != null && !sg.getSGDescription().isEmpty()) {
            buffy.append(" :- ");
            buffy.append(sg.getSGDescription().getDescription());
        }
        return buffy.toString();
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return this.subgroupInstanceIterator();
    }

    @Override
    public SGDescription getDescription() {
        return this.getSGDescription();
    }
}

