% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_polr.R, R/stan_polr.fit.R
\name{stan_polr}
\alias{stan_polr}
\alias{stan_polr.fit}
\title{Bayesian ordinal regression models via Stan}
\usage{
stan_polr(formula, data, weights, ..., subset,
  na.action = getOption("na.action", "na.omit"), contrasts = NULL,
  model = TRUE, method = c("logistic", "probit", "loglog", "cloglog",
  "cauchit"), prior = R2(stop("'location' must be specified")),
  prior_counts = dirichlet(1), shape = NULL, rate = NULL,
  prior_PD = FALSE, algorithm = c("sampling", "meanfield", "fullrank"),
  adapt_delta = NULL)

stan_polr.fit(x, y, wt = NULL, offset = NULL, method = c("logistic",
  "probit", "loglog", "cloglog", "cauchit"), ...,
  prior = R2(stop("'location' must be specified")),
  prior_counts = dirichlet(1), shape = NULL, rate = NULL,
  prior_PD = FALSE, algorithm = c("sampling", "meanfield", "fullrank"),
  adapt_delta = NULL)
}
\arguments{
\item{formula, data, subset}{Same as \code{\link[MASS]{polr}}.}

\item{weights, na.action, contrasts, model}{Same as \code{\link[MASS]{polr}}, but
rarely specified.}

\item{...}{Further arguments passed to the function in the \pkg{rstan} 
package (\code{\link[rstan]{sampling}}, \code{\link[rstan]{vb}}, or 
\code{\link[rstan]{optimizing}}), corresponding to the estimation method 
named by \code{algorithm}. For example, if \code{algorithm} is
\code{"sampling"} it is possibly to specify \code{iter}, \code{chains},
\code{cores}, \code{refresh}, etc.}

\item{method}{One of 'logistic', 'probit', 'loglog', 'cloglog' or 'cauchit',
but can be abbreviated. See \code{\link[MASS]{polr}} for more details.}

\item{prior}{Prior for coefficients. Should be a call to \code{\link{R2}} 
to specify the prior location of the \eqn{R^2} but can be \code{NULL}
to indicate a standard uniform prior. See \code{\link{priors}}.}

\item{prior_counts}{A call to \code{\link{dirichlet}} to specify the 
prior counts of the outcome when the predictors are at their sample
means.}

\item{shape}{Either \code{NULL} or a positive scalar that is interpreted
as the shape parameter for a \code{\link[stats]{GammaDist}}ribution on
the exponent applied to the probability of success when there are only
two outcome categories. If \code{NULL}, which is the default, then the
exponent is taken to be fixed at \eqn{1}.}

\item{rate}{Either \code{NULL} or a positive scalar that is interpreted
as the rate parameter for a \code{\link[stats]{GammaDist}}ribution on
the exponent applied to the probability of success when there are only
two outcome categories. If \code{NULL}, which is the default, then the
exponent is taken to be fixed at \eqn{1}.}

\item{prior_PD}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to draw from the prior predictive distribution instead of
conditioning on the outcome.}

\item{algorithm}{Character string (possibly abbreviated) indicating the 
estimation approach to use. Can be \code{"sampling"} for MCMC (the
default), \code{"optimizing"} for optimization, \code{"meanfield"} for
variational inference with independent normal distributions, or
\code{"fullrank"} for variational inference with a multivariate normal
distribution. See \code{\link{rstanarm-package}} for more details on the
estimation algorithms. NOTE: not all fitting functions support all four
algorithms.}

\item{adapt_delta}{Only relevant if \code{algorithm="sampling"}. See 
\code{\link{adapt_delta}} for details.}

\item{x}{A design matrix.}

\item{y}{A response variable, which must be a (preferably ordered) factor.}

\item{wt}{A numeric vector (possibly \code{NULL}) of observation weights.}

\item{offset}{A numeric vector (possibly \code{NULL}) of offsets.}
}
\value{
A \link[=stanreg-objects]{stanreg} object is returned 
for \code{stan_polr}.

A \link[=stanfit-class]{stanfit} object (or a slightly modified 
  stanfit object) is returned if \code{stan_polr.fit} is called directly.
}
\description{
Bayesian inference for ordinal (or binary) regression models under
a proportional odds assumption.
}
\details{
The \code{stan_polr} function is similar in syntax to 
  \code{\link[MASS]{polr}} but rather than performing maximum likelihood 
  estimation of a proportional odds model, Bayesian estimation is performed
  (if \code{algorithm = "sampling"}) via MCMC. The \code{stan_polr} 
  function calls the workhorse \code{stan_polr.fit} function, but it is 
  possible to call the latter directly.
  
  As for \code{\link{stan_lm}}, it is necessary to specify the prior 
  location of \eqn{R^2}. In this case, the \eqn{R^2} pertains to the
  proportion of variance in the latent variable (which is discretized
  by the cutpoints) attributable to the predictors in the model. 
  
  Prior beliefs about the cutpoints are governed by prior beliefs about the
  outcome when the predictors are at their sample means. Both of these
  are explained in the help page on \code{\link{priors}} and in the 
  \pkg{rstanarm} vignettes.
 
  Unlike \code{\link[MASS]{polr}}, \code{stan_polr} also allows the "ordinal"
  outcome to contain only two levels, in which case the likelihood is the
  same by default as for \code{\link{stan_glm}} with \code{family = binomial}
  but the prior on the coefficients is different. However, \code{stan_polr}
  allows the user to specify the \code{shape} and \code{rate} hyperparameters,
  in which case the probability of success is defined as the logistic CDF of
  the linear predictor, raised to the power of \code{alpha} where \code{alpha}
  has a gamma prior with the specified \code{shape} and \code{rate}. This
  likelihood is called \dQuote{scobit} by Nagler (1994) because if \code{alpha}
  is not equal to \eqn{1}, then the relationship between the linear predictor
  and the probability of success is skewed. If \code{shape} or \code{rate} is
  \code{NULL}, then \code{alpha} is assumed to be fixed to \eqn{1}. 
  
  Otherwise, it is usually advisible to set \code{shape} and \code{rate} to
  the same number so that the expected value of \code{alpha} is \eqn{1} while
  leaving open the possibility that \code{alpha} may depart from \eqn{1} a
  little bit. It is often necessary to have a lot of data in order to estimate
  \code{alpha} with much precision and always necessary to inspect the
  Pareto shape parameters calculated by \code{\link{loo}} to see if the 
  results are particularly sensitive to individual observations.
  
  Users should think carefully about how the outcome is coded when using 
  a scobit-type model. When \code{alpha} is not \eqn{1}, the asymmetry
  implies that the probability of success is most sensitive to the predictors
  when the probability of success is less than \eqn{0.63}. Reversing the
  coding of the successes and failures allows the predictors to have the
  greatest impact when the probability of failure is less than \eqn{0.63}.
  Also, the gamma prior on \code{alpha} is positively skewed, but you
  can reverse the coding of the successes and failures to circumvent this
  property.
}
\examples{
stan_polr(tobgp ~ agegp, data = esoph, method = "probit",
          prior = R2(0.2, "mean"), init_r = 0.1, seed = 12345,
          algorithm = "fullrank") # for speed only

}
\references{
Nagler, J., (1994). Scobit: An Alternative Estimator to Logit and Probit.
\emph{American Journal of Political Science}. 230 -- 255.
}
\seealso{
\code{\link{stanreg-methods}} and 
\code{\link[MASS]{polr}}.
}

