% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict}
\alias{posterior_predict}
\title{Draw from posterior predictive distribution}
\usage{
posterior_predict(object, newdata = NULL, draws = NULL, re.form = NULL,
  fun = NULL, seed = NULL, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{newdata}{Optionally, a data frame in which to look for variables with 
which to predict. If omitted, the model matrix is used. If \code{newdata} 
is provided and any variables were transformed (e.g. rescaled) in the data 
used to fit the model, then these variables must also be transformed in 
\code{newdata}. This only applies if variables were transformed before 
passing the data to one of the modeling functions and \emph{not} if 
transformations were specified inside the model formula.}

\item{draws}{An integer indicating the number of draws to return. The default
and maximum number of draws is the size of the posterior sample.}

\item{re.form}{If \code{object} contains \code{\link[=stan_glmer]{group-level}}
parameters, a formula indicating which group-level parameters to 
condition on when making predictions. \code{re.form} is specified in the 
same form as for \code{\link[lme4]{predict.merMod}}. The default, 
\code{NULL}, indicates that all estimated group-level parameters are 
conditioned on. To refrain from conditioning on any group-level parameters,
specify \code{NA} or \code{~0}. The \code{newdata} argument may include new
\emph{levels} of the grouping factors that were specified when the model 
was estimated, in which case the resulting posterior predictions 
marginalize over the relevant variables.}

\item{fun}{An optional function to apply to the results. \code{fun} is found 
by a call to \code{\link{match.fun}} and so can be specified as a function
object, a string naming a function, etc.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}

\item{...}{Currently unused.}
}
\value{
A \code{draws} by \code{nrow(newdata)} matrix of simulations
  from the posterior predictive distribution. Each row of the matrix is a
  vector of predictions generated using a single draw of the model parameters
  from the posterior distribution.
}
\description{
The posterior predictive distribution is the distribution of the outcome 
implied by the model after using the observed data to update our beliefs 
about the unknown parameters in the model. Simulating data from the posterior
predictive distribution using the observed predictors is useful for checking 
the fit of the model. Drawing from the posterior predictive distribution at 
interesting values of the predictors also lets us visualize how a 
manipulation of a predictor affects (a function of) the outcome(s). With new 
observations of predictor variables we can use posterior predictive 
distribution to generate predicted outcomes.
}
\examples{
yrep <- posterior_predict(example_model)
table(yrep)

\dontrun{
nd <- lme4::cbpp
nd$size <- max(nd$size) + 1L
ppd <- posterior_predict(example_model, newdata = nd)

# Use fun argument to transform predictions
fit <- stan_glm(I(log(mpg)) ~ wt, data = mtcars)
ppd <- posterior_predict(fit, fun = exp)
}

}
\seealso{
\code{\link{pp_check}} for graphical posterior predictive checks.
  Examples of posterior predictive checking can also be found in the
  \pkg{rstanarm} vignettes and demos.
}

