% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_mvmer.R
\name{stan_mvmer}
\alias{stan_mvmer}
\title{Bayesian multivariate generalized linear models with correlated 
group-specific terms via Stan}
\usage{
stan_mvmer(
  formula,
  data,
  family = gaussian,
  weights,
  prior = normal(),
  prior_intercept = normal(),
  prior_aux = cauchy(0, 5),
  prior_covariance = lkj(),
  prior_PD = FALSE,
  algorithm = c("sampling", "meanfield", "fullrank"),
  adapt_delta = NULL,
  max_treedepth = 10L,
  init = "random",
  QR = FALSE,
  sparse = FALSE,
  ...
)
}
\arguments{
\item{formula}{A two-sided linear formula object describing both the 
fixed-effects and random-effects parts of the longitudinal submodel  
similar in vein to formula specification in the \strong{lme4} package
(see \code{\link[lme4]{glmer}} or the \strong{lme4} vignette for details). 
Note however that the double bar (\code{||}) notation is not allowed 
when specifying the random-effects parts of the formula, and neither
are nested grouping factors (e.g. \code{(1 | g1/g2))} or 
\code{(1 | g1:g2)}, where \code{g1}, \code{g2} are grouping factors. 
For a multivariate GLM this should be a list of such formula objects, 
with each element of the list providing the formula for one of the 
GLM submodels.}

\item{data}{A data frame containing the variables specified in
\code{formula}. For a multivariate GLM, this can
be either a single data frame which contains the data for all 
GLM submodels, or it can be a list of data frames where each
element of the list provides the data for one of the GLM submodels.}

\item{family}{The family (and possibly also the link function) for the 
GLM submodel(s). See \code{\link[lme4]{glmer}} for details. 
If fitting a multivariate GLM, then this can optionally be a
list of families, in which case each element of the list specifies the
family for one of the GLM submodels. In other words, a different family
can be specified for each GLM submodel.}

\item{weights}{Same as in \code{\link[stats]{glm}},
except that when fitting a multivariate GLM and a list of data frames 
is provided in \code{data} then a corresponding list of weights 
must be provided. If weights are 
provided for one of the GLM submodels, then they must be provided for 
all GLM submodels.}

\item{prior, prior_intercept, prior_aux}{Same as in \code{\link{stan_glmer}}
except that for a multivariate GLM a list of priors can be provided for 
any of \code{prior}, \code{prior_intercept} or \code{prior_aux} arguments. 
That is, different priors can optionally be specified for each of the GLM  
submodels. If a list is not provided, then the same prior distributions are 
used for each GLM submodel. Note that the \code{"product_normal"} prior is
not allowed for \code{stan_mvmer}.}

\item{prior_covariance}{Cannot be \code{NULL}; see \code{\link{priors}} for
more information about the prior distributions on covariance matrices.
Note however that the default prior for covariance matrices in 
\code{stan_mvmer} is slightly different to that in \code{\link{stan_glmer}} 
(the details of which are described on the \code{\link{priors}} page).}

\item{prior_PD}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to draw from the prior predictive distribution instead of
conditioning on the outcome.}

\item{algorithm}{A string (possibly abbreviated) indicating the 
estimation approach to use. Can be \code{"sampling"} for MCMC (the
default), \code{"optimizing"} for optimization, \code{"meanfield"} for
variational inference with independent normal distributions, or
\code{"fullrank"} for variational inference with a multivariate normal
distribution. See \code{\link{rstanarm-package}} for more details on the
estimation algorithms. NOTE: not all fitting functions support all four
algorithms.}

\item{adapt_delta}{Only relevant if \code{algorithm="sampling"}. See 
the \link{adapt_delta} help page for details.}

\item{max_treedepth}{A positive integer specifying the maximum treedepth 
for the non-U-turn sampler. See the \code{control} argument in 
\code{\link[rstan]{stan}}.}

\item{init}{The method for generating initial values. See
\code{\link[rstan]{stan}}.}

\item{QR}{A logical scalar defaulting to \code{FALSE}, but if \code{TRUE}
applies a scaled \code{\link{qr}} decomposition to the design matrix. The
transformation does not change the likelihood of the data but is
recommended for computational reasons when there are multiple predictors.
See the \link{QR-argument} documentation page for details on how
\pkg{rstanarm} does the transformation and important information about how
to interpret the prior distributions of the model parameters when using
\code{QR=TRUE}.}

\item{sparse}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to use a sparse representation of the design (X) matrix. 
If \code{TRUE}, the the design matrix is not centered (since that would 
destroy the sparsity) and likewise it is not possible to specify both 
\code{QR = TRUE} and \code{sparse = TRUE}. Depending on how many zeros
there are in the design matrix, setting \code{sparse = TRUE} may make
the code run faster and can consume much less RAM.}

\item{...}{Further arguments passed to the function in the \pkg{rstan} 
package (\code{\link[rstan]{sampling}}, \code{\link[rstan]{vb}}, or 
\code{\link[rstan]{optimizing}}), corresponding to the estimation method 
named by \code{algorithm}. For example, if \code{algorithm} is
\code{"sampling"} it is possibly to specify \code{iter}, \code{chains},
\code{cores}, \code{refresh}, etc.}
}
\value{
A \link[=stanreg-objects]{stanmvreg} object is returned.
}
\description{
\if{html}{\figure{stanlogo.png}{options: width="25px" alt="http://mc-stan.org/about/logo/"}}
Bayesian inference for multivariate GLMs with group-specific coefficients 
that are assumed to be correlated across the GLM submodels.
}
\details{
The \code{stan_mvmer} function can be used to fit a multivariate
  generalized linear model (GLM) with group-specific terms. The model consists
  of distinct GLM submodels, each which contains group-specific terms; within
  a grouping factor (for example, patient ID) the grouping-specific terms are
  assumed to be correlated across the different GLM submodels. It is 
  possible to specify a different outcome type (for example a different
  family and/or link function) for each of the GLM submodels. \cr
  \cr
  Bayesian estimation of the model is performed via MCMC, in the same way as 
  for \code{\link{stan_glmer}}. Also, similar to \code{\link{stan_glmer}},
  an unstructured covariance matrix is used for the group-specific terms 
  within a given grouping factor, with priors on the terms of a decomposition
  of the covariance matrix.See \code{\link{priors}} for more information about 
  the priors distributions that are available for the covariance matrices, 
  the regression coefficients and the intercept and auxiliary parameters.
}
\examples{
\donttest{
#####
# A multivariate GLM with two submodels. For the grouping factor 'id', the 
# group-specific intercept from the first submodel (logBili) is assumed to
# be correlated with the group-specific intercept and linear slope in the 
# second submodel (albumin)
f1 <- stan_mvmer(
        formula = list(
          logBili ~ year + (1 | id), 
          albumin ~ sex + year + (year | id)),
        data = pbcLong, 
        # this next line is only to keep the example small in size!
        chains = 1, cores = 1, seed = 12345, iter = 1000)
summary(f1) 

#####
# A multivariate GLM with one bernoulli outcome and one
# gaussian outcome. We will artificially create the bernoulli
# outcome by dichotomising log serum bilirubin
pbcLong$ybern <- as.integer(pbcLong$logBili >= mean(pbcLong$logBili))
f2 <- stan_mvmer(
        formula = list(
          ybern ~ year + (1 | id), 
          albumin ~ sex + year + (year | id)),
        data = pbcLong,
        family = list(binomial, gaussian),
        chains = 1, cores = 1, seed = 12345, iter = 1000)
}

}
\seealso{
\code{\link{stan_glmer}}, \code{\link{stan_jm}},
  \code{\link{stanreg-objects}}, \code{\link{stanmvreg-methods}}, 
  \code{\link{print.stanmvreg}}, \code{\link{summary.stanmvreg}},
  \code{\link{posterior_predict}}, \code{\link{posterior_interval}}.
}
