% Generated by roxygen2 (4.0.2): do not edit by hand
\name{head.rstack}
\alias{head.rstack}
\title{Return the head (top) of an rstack}
\usage{
\method{head}{rstack}(x, n = 6L, ...)
}
\arguments{
\item{x}{rstack to get the head/top of.}

\item{n}{number of elements to get.}

\item{...}{arguments to be passed to or from other methods (ignored).}
}
\value{
an \code{\link{rstack}}.
}
\description{
Returns the top \eqn{n} elements of an rstack as an stack, or all of the elements
if \code{length(x) < n}.
}
\details{
Runs in \eqn{O(n)} time (in the size of the number of elements requested).
}
\examples{
s <- rstack()
s <- insert_top(s, "a")
s <- insert_top(s, "b")
s <- insert_top(s, "c")

st <- head(s, n = 2)
print(st)
print(s)
}
\seealso{
\code{\link{rstack}}.
}

