% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assets_download.R
\name{assets_download}
\alias{assets_download}
\title{Downloads assets via STAC API}
\usage{
assets_download(
  items,
  assets_name,
  output_dir = ".",
  overwrite = FALSE,
  items_max = Inf,
  progress = TRUE,
  ...
)
}
\arguments{
\item{items}{a \code{STACItem} or \code{STACItemCollection} object
representing the result of \code{/stac/search},
\code{/collections/{collectionId}/items} or
\code{/collections/{collectionId}/items/{itemId}} endpoints.}

\item{assets_name}{a \code{character} with the assets names to be filtered.}

\item{output_dir}{a \code{character} directory in which the assets will be
saved.}

\item{overwrite}{a \code{logical} if TRUE will replaced the existing file,
if FALSE a warning message is shown.}

\item{items_max}{a \code{numeric} corresponding how many items will be
downloaded.}

\item{progress}{a \code{logical} indicating if a progress bar must be
shown or not. Defaults to \code{TRUE}.}

\item{...}{config parameters to be passed to \link[httr]{GET} or
\link[httr]{POST} methods, such as \link[httr]{add_headers} or
\link[httr]{set_cookies}.}
}
\value{
The same \code{STACItemCollection} or \code{STACItem} object, with
the link of the item pointing to the directory where the assets were saved.
}
\description{
The \code{assets_download} function downloads the assets
provided by the STAC API.
}
\examples{
\dontrun{
stac("http://brazildatacube.dpi.inpe.br/stac/") \%>\%
  stac_search(collections = "CB4_64_16D_STK-1") \%>\%
  stac_search(limit = 2) \%>\%
  get_request() \%>\%
  assets_download(assets_name = "thumbnail", output_dir = ".",
  overwrite = FALSE)
}

}
\seealso{
\code{\link{stac_search}}, \code{\link{items}}, \code{\link{get_request}}
}
