% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_GLI.R
\name{raw_GLI}
\alias{raw_GLI}
\title{Convert z-scores back to raw spirometric values using GLI-2012 equations}
\usage{
raw_GLI(
  age,
  height,
  gender = 1,
  ethnicity = 1,
  FEV1 = NULL,
  FVC = NULL,
  FEV1FVC = NULL,
  FEF2575 = NULL,
  FEF75 = NULL,
  FEV075 = NULL,
  FEV075FVC = NULL
)
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{ethnicity}{Ethnicity (1 = Caucasian, 2 = African-American, 3 = NE Asian, 4 = SE Asian,
5 = Other/mixed). Default is 1.}

\item{FEV1}{Forced Expiratory Volume in 1 second (z-score)}

\item{FVC}{Forced Vital Capacity (z-score)}

\item{FEV1FVC}{FEV1 / FVC (as z-score)}

\item{FEF2575}{Forced Expiratory Flow between 25\% and 75\% of FVC (z-score)}

\item{FEF75}{Forced Expiratory Flow at 75\% of FVC (z-score)}

\item{FEV075}{Forced Expiratory Volume in 0.75 sec (z-score)}

\item{FEV075FVC}{FEV0.75 / FVC (as z-score)}
}
\value{
If only one spirometry z-score argument is supplied, the function
returns a numeric vector. If more are supplied, the function returns 
a data.frame with the same number of columns.
}
\description{
This function takes z-scores based on the GLI-2012 equations, plus
demographic data (age, height, gender and ethnicity), and converts them back
into absolute spirometry measurements (FEV1, FVC, etc) in lt.
}
\details{
At least one of the spirometric z-score arguments must be set (i.e. be
non-\code{NULL}). Arguments \code{age}, \code{height}, \code{gender} and
\code{ethnicity} must be vectors of length equal to the length of the
z-score vector(s), or of length one, in which case their value is recycled.
If any input vector is not of equal length, the function stops with an error.
}
\examples{
# Random data, 4 patients, one z-score parameter supplied (FEV1)
raw_GLI(age=seq(25,40,5), height=c(1.8, 1.9, 1.75, 1.85),
      gender=c(2,1,2,1), FEV1=c(-1.2, -1.9, 0, 0.5))

}
