% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_PureSVD.R
\name{PureSVD}
\alias{PureSVD}
\title{PureSVD recommender model decompomposition}
\description{
Creates PureSVD recommender model. Solver is based on Soft-SVD which is
very similar to truncated SVD but optionally adds regularization based on nuclear norm.
}
\examples{
data('movielens100k')
i_train = sample(nrow(movielens100k), 900)
i_test = setdiff(seq_len(nrow(movielens100k)), i_train)
train = movielens100k[i_train, ]
test = movielens100k[i_test, ]
rank = 32
lambda = 0
model = PureSVD$new(rank = rank,  lambda = lambda)
user_emb = model$fit_transform(sign(test), n_iter = 100, convergence_tol = 0.00001)
item_emb = model$components
preds = model$predict(sign(test), k = 1500, not_recommend = NULL)
mean(ap_k(preds, actual = test))
}
\section{Super class}{
\code{\link[rsparse:MatrixFactorizationRecommender]{rsparse::MatrixFactorizationRecommender}} -> \code{PureSVD}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PureSVD$new()}}
\item \href{#method-fit_transform}{\code{PureSVD$fit_transform()}}
\item \href{#method-transform}{\code{PureSVD$transform()}}
\item \href{#method-clone}{\code{PureSVD$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rsparse" data-topic="MatrixFactorizationRecommender" data-id="predict">}\href{../../rsparse/html/MatrixFactorizationRecommender.html#method-predict}{\code{rsparse::MatrixFactorizationRecommender$predict()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
create PureSVD model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PureSVD$new(
  rank = 10L,
  lambda = 0,
  init = NULL,
  preprocess = identity,
  method = c("svd", "impute"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rank}}{size of the latent dimension}

\item{\code{lambda}}{regularization parameter}

\item{\code{init}}{initialization of item embeddings}

\item{\code{preprocess}}{\code{identity()} by default. User spectified function which will
be applied to user-item interaction matrix before running matrix factorization
(also applied during inference time before making predictions).
For example we may want to normalize each row of user-item matrix to have 1 norm.
Or apply \code{log1p()} to discount large counts.}

\item{\code{method}}{type of the solver for initialization of the orthogonal
basis. Original paper uses SVD. See paper for details.}

\item{\code{...}}{not used at the moment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit_transform"></a>}}
\if{latex}{\out{\hypertarget{method-fit_transform}{}}}
\subsection{Method \code{fit_transform()}}{
performs matrix factorization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PureSVD$fit_transform(x, n_iter = 100L, convergence_tol = 0.001, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{input sparse user-item matrix(of class \code{dgCMatrix})}

\item{\code{n_iter}}{maximum number of iterations}

\item{\code{convergence_tol}}{\code{numeric = -Inf} defines early stopping strategy.
Stops fitting when one of two following conditions will be satisfied: (a) passed
all iterations (b) relative change of Frobenious norm of the two consequent solution
is less then provided \code{convergence_tol}.}

\item{\code{...}}{not used at the moment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\if{latex}{\out{\hypertarget{method-transform}{}}}
\subsection{Method \code{transform()}}{
calculates user embeddings for the new input
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PureSVD$transform(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{input matrix}

\item{\code{...}}{not used at the moment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PureSVD$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
