% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_FactorizationMachine.R
\docType{data}
\name{FactorizationMachine}
\alias{FactorizationMachine}
\title{Creates FactorizationMachine model.}
\format{\code{R6Class} object.}
\usage{
FactorizationMachine
}
\description{
Creates second order Factorization Machines model
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
fm = FM$new(learning_rate_w = 0.2, rank = 4, lambda_w = 0, lambda_v = 0, family = c("binomial", "gaussian")
  intercept = TRUE, learning_rate_v = learning_rate_w)
fm$partial_fit(x, y, ...)
fm$predict(x, ...)
}
}

\section{Methods}{

\describe{
  \item{\code{FM$new(learning_rate_w = 0.2, rank = 4, lambda_w = 0, lambda_v = 0,
  family = c("binomial", "gaussian"), intercept = TRUE, learning_rate_v = learning_rate_w)}}{Constructor
  for FactorizationMachines model. For description of arguments see \bold{Arguments} section.}
  \item{\code{$partial_fit(x, y, ...)}}{fits/updates model given input matrix \code{x} and target vector \code{y}.
  \code{x} shape = (n_samples, n_features)}
  \item{\code{$predict(x, ...)}}{predicts output \code{x}}
}
}

\section{Arguments}{

\describe{
 \item{fm}{\code{FM} object}
 \item{x}{Input sparse matrix - native format is \code{Matrix::RsparseMatrix}.
 If \code{x} is in different format, model will try to convert it to \code{RsparseMatrix}
 with \code{as(x, "RsparseMatrix")} call}
 \item{learning_rate_w}{learning rate for linear weights in AdaGrad SGD}
 \item{learning_rate_v}{learning rate for interactions in AdaGrad SGD}
 \item{rank}{rank of the latent dimension in factorization}
 \item{lambda_w}{regularization parameter for linear terms}
 \item{lambda_v}{regularization parameter for interactions terms}
 \item{intercept}{logical flag which specify whether to allow model to have non-zero
      intercept/bias}
 \item{family}{ a description of the error distribution and link function to be used in the model.
       Can be \code{"gaussian"} (for regression) or \code{"binomial"} (for classification)}
}
}

\examples{
\donttest{
# Factorization Machines can fit XOR function!
x = rbind(
  c(0, 0),
  c(0, 1),
  c(1, 0),
  c(1, 1)
)
y = c(0, 1, 1, 0)

x = as(x, "RsparseMatrix")
fm = FactorizationMachine$new(learning_rate_w = 10, rank = 2, lambda_w = 0,
  lambda_v = 0, family = 'binomial', intercept = TRUE)
res = fm$fit(x, y, n_iter = 100)
preds = fm$predict(x)
all(preds[c(1, 4)] < 0.01)
all(preds[c(2, 3)] > 0.99)
}
}
\keyword{datasets}
