% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{p_model_validation}
\alias{p_model_validation}
\title{SOFUN p-model GPP validation data}
\format{
A tibble of validation data:
\describe{
  \item{sitename}{A character string containing the site name (e.g. 'FR-Pue').}
  \item{data}{A tibble [ 2,920 x 3 ] with time series for the following variables:
    \describe{
      \item{date}{Date vector with format YYYY-MM-DD.}
      \item{gpp}{The observed Gross Primary Productivity (GPP) for each time stamp 
      (in gC m\eqn{^{-2}} d\eqn{^{-1}}).}
      \item{gpp_unc}{The uncertainty of the GPP (in gC m\eqn{^{-2}} d\eqn{^{-1}}).}
    }
  }
}
}
\source{
Pastorello, G., Trotta, C., Canfora, E. et al. 
The FLUXNET2015 dataset and the ONEFlux processing pipeline for eddy covariance data. 
Sci Data 7, 225 (2020). https://doi.org/10.1038/s41597-020-0534-3
}
\usage{
p_model_validation
}
\description{
Small tests dataset to validate 
calibration routines for a time series of fluxes.
}
\examples{
require(ggplot2); require(tidyr)
p_model_validation \%>\% tidyr::unnest(data) 

}
\keyword{datasets}
