% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss.R
\name{miss}
\alias{miss}
\title{miss}
\usage{
miss(data, estvarname, se, par = NULL, methodvar = NULL, by = NULL)
}
\arguments{
\item{data}{A \code{data.frame} in which variable names are interpreted. It has to be in tidy format, e.g. each variable forms a column and each observation forms a row.}

\item{estvarname}{The name of the variable containing the point estimates.}

\item{se}{The name of the variable containing the standard errors of the point estimates.}

\item{par}{The name of the variable containing the different estimands from the simulation study. Can be \code{NULL}.}

\item{methodvar}{The name of the variable containing the methods to compare. Can be \code{NULL}.}

\item{by}{A vector of variable names to compute performance measures by a list of factors. Can be \code{NULL}.}
}
\value{
An object of class \code{miss}.
}
\description{
Obtain basic information on the proportion of missing data within the results of a simulation study.
}
\examples{
library(rsimsum)
data("frailty", package = "rsimsum")
miss(data = frailty, estvarname = "b", se = "se", par = "par",
       methodvar = "model", by = "fv_dist")
}
