% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsdNE.R
\name{asym2}
\alias{asym2}
\title{This generates a class of asymmetric rotatable response surface designs with neighbour effects under a polynomial model of order max(s1,s2)-1}
\usage{
asym2(s1, n1, s2, n2, c)
}
\arguments{
\item{s1}{Number of levels of n1 factors, 1<s1<=8}

\item{n1}{Number of factors, 1<=n1<=4}

\item{s2}{Number of levels of n2 factors, 1<s2<=8}

\item{n2}{Number of factors, 1<=n2<=4}

\item{c}{Value of alpha (Coefficient of neighbour effects), 0<=c<=1}
}
\value{
his function generates rotatable designs as well as Z_prime_Z matrix,
inv(Z_primeZ) matrix and variance estimated response for the (s1^n1 * s2^n2) factorial combination.
}
\description{
This function generates asymmetrical rotatable response surface designs in the presence of neighbour effects for (n1 + n2) factors, n1 factors at s1 levels and another n2 factors at s2 levels.
}
\note{
Here s1 and s2 both not even at the same time and s1 not equal to s2.
}
\examples{
library(rsdNE)
asym2(2,2,5,2,0.5)
}
\references{
Dalal, 2021, Unpublished M.Sc. Thesis, IARI, New Delhi
}
\author{
Ashutosh Dalal, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Seema Jaggi, Education Division, ICAR, Krishi Anusandhan Bhawan - II, Pusa, New Delhi.
Eldho Varghese,Fishery Resources Assessment Division,ICAR-CMFRI, Kochi.
Subhasish Sarkar, Division of Computer Application,ICAR-IASRI, New Delhi.
Arpan Bhowmik, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Cini Varghese, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Anindita Datta, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Soumen Pal, Division of Computer Application,ICAR-IASRI, New Delhi.
}
