% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entitlement_retrieval.R
\name{entitlement_retrieval}
\alias{entitlement_retrieval}
\title{ScienceDirect Text Entitlement Retrieval}
\usage{
entitlement_retrieval(id, identifier = c("scopus_id", "eid", "doi",
  "pii", "pubmed_id"), http_end = NULL, ...)
}
\arguments{
\item{id}{Identifier for entitlement}

\item{identifier}{Type of identifier to use}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to give a
retrieval of an entitlement from the Elsevier Text Entitlement API
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = entitlement_retrieval("S1053811915002700", identifier = "pii",
   verbose = FALSE)
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}
