% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_journal_metrics.R
\name{get_journal_metrics}
\alias{get_journal_metrics}
\title{Scrape publication and citation counts of a journal hosted on Scielo}
\usage{
get_journal_metrics(journal_id)
}
\arguments{
\item{journal_id}{a character vector with the ID of the journal hosted on
Scielo (the \code{get_journal_id} function can be used to find a journal's
ID from its URL).}
}
\value{
The function returns a \code{tibble} with the following variables:

\itemize{
  \item year: Year.
  \item n_issues: Number of issues in that year.
  \item n_articles: Number of articles in that year.
  \item granted_citations: Granted citations by the journal in that year.
  \item received_citations: Received citations by the journal in that year.
  \item avg_art_per_issues: Average number of articles published by the
  journal in that year.
}
}
\description{
\code{get_journal_metrics()} scrapes publication and citation counts
of a jornal hosted on Scielo.
}
\note{
Sometimes, the Scielo website is offline for maintaince,
in which cases this function will not work (i.e., users will get HTML status
different from the usual 200 OK).
}
\examples{
\donttest{
df <- get_journal_metrics(journal_id = "1981-3821")
}
}
