% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documents.R
\name{documents}
\alias{documents}
\title{documents}
\usage{
documents(
  prgs,
  type = c("vars", "funs", "names"),
  ignore.case = TRUE,
  minlen = 2,
  ...
)
}
\arguments{
\item{prgs}{prgs sourcecode object}

\item{type}{character: either \code{"vars"}, \code{"funs"}, \code{"names"} (default: \code{"vars"})}

\item{ignore.case}{logical: If TRUE, case is ignored for computing (default: \code{TRUE})}

\item{minlen}{integer: minimal name length to be considered (default: \code{2})}

\item{...}{unused}
}
\value{
a
}
\description{
Creates word vectors from parsed sourec code objects. If
\itemize{
\item \code{type=="vars"} then the names of \code{all.vars(.)},
\item \code{type=="funs"} then the namas of \code{setdiff(all.names(.), all.vars(.)}, and
\item \code{type=="names"} then the names of \code{all.names(.)}
}
are used.
}
\examples{
# example files are taken from https://CRAN.R-project.org/package=SimilaR
files <- list.files(system.file("examples", package="rscc"), "*.R$", full.names=TRUE)
prgs  <- sourcecode(files, basename=TRUE)
docs  <- documents(prgs)
docs
}
