#' @rdname scalaPush
#'
#' @param reference An rscala reference.
#'
#' @export
#' 
scalaPull <- function(reference, method, ...) {
  if ( ! is.scalaReference(reference) ) stop("An rscala reference is required.")
  bridge <- scalaFindBridge(reference)
  pullers <- get("pullers",envir=attr(bridge,"details"))
  pullers[[method]](reference, bridge, ...)
}

scalaPull.list <- function(reference, bridge) {
  if ( ! grepl("List\\d+",scalaType(reference)) ) stop("This is not a reference to a list.")
  names <- reference$names()
  asIs <- reference$asIs()
  x <- lapply(seq_along(names),function(i) {
    x <- eval(parse(text=paste0("reference$",names[i],"()")))
    if ( asIs[i] ) I(x) else x
  })
  names(x) <- names
  if ( ! reference$isDataFrame() ) x
  else {
    rowNamesOptions <- reference$rowNames()
    rowNames <- if ( rowNamesOptions$isDefined() ) rowNamesOptions$get() else NULL
    as.data.frame(x,row.names=rowNames,stringsAsFactors=FALSE)
  }
}

scalaPull.generic <- function(reference, bridge) {
  type <- scalaType(reference) 
  if ( type == "org.ddahl.rscala.RObject" ) unserialize(reference$x())
  else if ( type == "List[org.ddahl.rscala.RObject]" ) {
    pair <- bridge(arr=reference) ^ '(arr.flatMap(_.x).toArray, arr.scanLeft(1)((sum,y) => sum + y.x.length).toArray)'
    bytes <- pair$"_1"()
    sizes <- pair$"_2"()
    lapply(seq_along(sizes[-1]), function(i) {
      unserialize(bytes[sizes[i]:(sizes[i+1]-1)])
    }) 
  } else stop("Reference is not an RObject or a List[RObject].")
}
