% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc.R
\name{group_mc_cv}
\alias{group_mc_cv}
\title{Group Monte Carlo Cross-Validation}
\usage{
group_mc_cv(
  data,
  group,
  prop = 3/4,
  times = 25,
  ...,
  strata = NULL,
  pool = 0.1
)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A variable in \code{data} (single character or name) used for
grouping observations with the same value to either the analysis or
assessment set within a fold.}

\item{prop}{The proportion of data to be retained for modeling/analysis.}

\item{times}{The number of times to repeat the sampling.}

\item{...}{Not currently used.}

\item{strata}{A variable in \code{data} (single character or name) used to conduct
stratified sampling. When not \code{NULL}, each resample is created within the
stratification variable. Numeric \code{strata} are binned into quartiles.}

\item{pool}{A proportion of data used to determine if a particular group is
too small and should be pooled into another group. We do not recommend
decreasing this argument below its default of 0.1 because of the dangers
of stratifying groups that are too small.}
}
\value{
A tibble with classes \code{group_mc_cv},
\code{rset}, \code{tbl_df}, \code{tbl}, and \code{data.frame}.
The results include a column for the data split objects and an
identification variable.
}
\description{
Group Monte Carlo cross-validation creates splits of the data based
on some grouping variable (which may have more than a single row
associated with it). One resample of Monte Carlo cross-validation takes a
random sample (without replacement) of groups in the original data set to be
used for analysis. All other data points are added to the assessment set.
A common use of this kind of resampling is when you have
repeated measures of the same subject.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(ames, package = "modeldata")

set.seed(123)
group_mc_cv(ames, group = Neighborhood, times = 5)
\dontshow{\}) # examplesIf}
}
