% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imgInt.R
\name{imgInt}
\alias{imgInt}
\title{imgInt}
\usage{
imgInt(env.data, env.dates, target.dates, time.buffer, xy = NULL)
}
\arguments{
\item{env.data}{Object of class \emph{RasterStack}, \emph{RasterBrick} or \emph{data.frame}.}

\item{env.dates}{Object of class \emph{Date} with dates of \emph{env.data}.}

\item{target.dates}{Object of class \emph{Date} with target dates.}

\item{time.buffer}{A two-element vector with temporal search buffer (expressed in days).}

\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}
}
\value{
A \emph{RasterBrick} or a \emph{data frame}. If a \emph{RasterBrick}, each layer represents a date. If a \emph{data.frame}, columns represent dates and rows represent samples.
}
\description{
{Temporal linear interpolation of environmental data using
a \emph{raster}, \emph{SpatialPointsDataFrames} or \emph{data frames}.}
}
\details{
{Performs a pixel-wise linear interpolation over a raster for a given set of dates (\emph{target.dates}).
A temporal buffer (\emph{time.buffer}) is required to limit the search for reference data points (\emph{time.buffer}).
This is defined by a two element vector which limits the search in the past and future. If \emph{xy} is provided and
\emph{env.data} is a \emph{raster} object the function only considers the pixels that overlap with the shapefile.
Otherwise, all pixels are considered providing a \emph{RasterBrick}. However, if \emph{env.data} is a \emph{data.frame},
\emph{xy} is ignored.}
}
\examples{
{

 require(raster)

 #'  # read raster data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'ndvi.tif', full.names=TRUE)
 r.stk <- stack(file)
 r.stk <- stack(r.stk, r.stk, r.stk) # dummy files for the example

 # read movement data
 data(shortMove)

 # raster dates
 file.name <- names(r.stk)
 env.dates <- as.Date(paste0(substr(file.name, 2, 5), '-',
 substr(file.name, 7, 8), '-', substr(file.name, 10, 11)))

 # target dates
 target.dates = as.Date("2013-08-10")

 # interpolate raster data to target dates
 i.env.data <- imgInt(r.stk, env.dates, target.dates, c(60,60), xy=shortMove)

}
}
\seealso{
\code{\link{dataQuery}} \code{\link{timeDir}} \code{\link{spaceDir}} \code{\link{moveSeg}}
}
