% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segRaster.R
\name{segRaster}
\alias{segRaster}
\title{segRaster}
\usage{
segRaster(img, break.point = 0.1, min.value = 0.5)
}
\arguments{
\item{img}{Object of class \emph{RasterLayer}.}

\item{break.point}{Difference threshold. Default is 0.05.}

\item{min.value}{Minimum value. Default is 0.5.}
}
\value{
A list object.
}
\description{
{Connected-region based raster segmentation that preserves spatial gradients.}
}
\details{
{The function segments an input raster layer (\emph{img}) using a
connected component region labeling approach. For each pixel, the function
estimates the difference between it and its immediate neighbors. If the
difference is below the threshold defined by \emph{break.point} these are
aggregated into a single region. Moreover, the user can define a minimum pixel
value using \emph{min.value} which will ignore all pixels below that value. The
output of this function consists of:
\itemize{
 \item{\emph{regions} - Region raster image.}
 \item{\emph{stats} - Basic statistics for each pixel region.}}}
}
\examples{
{

 require(raster)

 # load example probability image
 file <- system.file('extdata', 'konstanz_probabilities.tif', package="rsMove")
 r <- raster(file)

 # segment probabilities
 rs <- segRaster(r)

}
}
\seealso{
\code{\link{predictResources}}
}
