% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backSample.R
\name{backSample}
\alias{backSample}
\title{backSample}
\usage{
backSample(xy = xy, region.id = region.id,
  sampling.method = sampling.method, env.data = env.data,
  nr.samples = NULL)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} of \emph{SpatialPointsDataFrame}.}

\item{region.id}{Vector of region identifiers for each sample.}

\item{sampling.method}{One of \emph{random} or \emph{pca}. Default is \emph{random}.}

\item{env.data}{Object of class \emph{RasterLayer}, \emph{RasterStack} or \emph{RasterBrick}.}

\item{nr.samples}{Number of random background samples.}
}
\value{
A \emph{SpatialPoints} or a \emph{SpatialPointsDataFrame} of background samples for unique pixels in \emph{env.data}.
}
\description{
Background sample selection.
}
\details{
{First, the function determines the unique pixel coordinates for \emph{xy} based on the dimensions
of \emph{env.data} and retrieves n background samples where n is determined by \emph{nr.samples}. Then, the
selection of samples is dependent on the method chosen by the user. If \emph{sampling.method} is set to \emph{random},
the function will select samples randomly. However, if \emph{pca} is used, the function will use a Principal
Components Analysis (PCA) over \emph{env.data} to evaluate the similarity between the samples associated to \emph{xy}
and the initial set of random samples First, based on this PCA, the function selects the most important Principal Components
(PC's) using the kaiser rule (i.e. PC's with eigenvalues greater than 1). Then, for each PC, the function estimates
the median and the Median Absolute Deviation (MAD) for each unique identifier in \emph{region.id}) and selects background
samples where the difference between their variance and the variance of the region samples exceeds the MAD. Then, the
algorithm removes the background samples that were not selected by all sample regions.}

If
\emph{nr.samples} is not provided all background pixels are returned

object.
}
\examples{
{

 require(raster)

 # read raster data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'ndvi.tif', full.names=TRUE)
 r.stk <- stack(file)

 # read movement data
 data(shortMove)

 # find sample regions
 label <- labelSample(xy=shortMove, agg.radius=500, nr.pixels=2, pixel.res=30)

 # select background samples
 ind <- which(label>0) # selected samples
 bSamples <- backSample(xy=shortMove[ind,], region.id=label[ind],
 env.data=r.stk, sampling.method='random')

}
}
\references{
\href{10.1002/rse2.70}{Remelgado, R., Leutner, B., Safi, K., Sonnenschein, R., Kuebert, C. and Wegmann, M. (2017), Linking animal movement and remote sensing - mapping resource suitability from a remote sensing perspective. Remote Sens Ecol Conserv.}
}
\seealso{
\code{\link{labelSample}} \code{\link{hotMove}} \code{\link{dataQuery}}
}
