/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.pipeline;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.SinkWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkTripleNodeTransform
extends SinkWrapper<Triple> {
    private final NodeTransform subjTransform;
    private final NodeTransform predTransform;
    private final NodeTransform objTransform;

    public SinkTripleNodeTransform(Sink<Triple> sink, NodeTransform nodeTransform) {
        this(sink, nodeTransform, nodeTransform, nodeTransform);
    }

    public SinkTripleNodeTransform(Sink<Triple> sink, NodeTransform subjTransform, NodeTransform predTransform, NodeTransform objTransform) {
        super(sink);
        this.subjTransform = subjTransform;
        this.predTransform = predTransform;
        this.objTransform = objTransform;
    }

    @Override
    public void send(Triple triple) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = SinkTripleNodeTransform.apply(this.subjTransform, s);
        Node p1 = SinkTripleNodeTransform.apply(this.predTransform, p);
        Node o1 = SinkTripleNodeTransform.apply(this.objTransform, o);
        if (s != s1 || p != p1 || o != o1) {
            triple = new Triple(s1, p1, o1);
        }
        super.send(triple);
    }

    private static Node apply(NodeTransform nodeTransform, Node node) {
        if (nodeTransform == null) {
            return node;
        }
        return nodeTransform.convert(node);
    }
}

